/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.Version;
import java.util.Objects;

class Restriction {
    public static final Restriction EVERYTHING = new Restriction(null, false, null, false);
    private Version lowerBound;
    private boolean lowerBoundInclusive;
    private Version upperBound;
    private boolean upperBoundInclusive;

    public Restriction(Version lowerBound, boolean lowerBoundInclusive, Version upperBound, boolean upperBoundInclusive) {
        this.lowerBound = lowerBound;
        this.lowerBoundInclusive = lowerBoundInclusive;
        this.upperBound = upperBound;
        this.upperBoundInclusive = upperBoundInclusive;
    }

    public Version getLowerBound() {
        return this.lowerBound;
    }

    public boolean isLowerBoundInclusive() {
        return this.lowerBoundInclusive;
    }

    public Version getUpperBound() {
        return this.upperBound;
    }

    public boolean isUpperBoundInclusive() {
        return this.upperBoundInclusive;
    }

    public boolean containsVersion(Version version) {
        int comparison;
        if (this.lowerBound != null) {
            comparison = this.lowerBound.compareTo(version);
            if (comparison == 0 && !this.lowerBoundInclusive) {
                return false;
            }
            if (comparison > 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            comparison = this.upperBound.compareTo(version);
            if (comparison == 0 && !this.upperBoundInclusive) {
                return false;
            }
            return comparison >= 0;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Restriction that = (Restriction)o;
        return this.lowerBoundInclusive == that.lowerBoundInclusive && this.upperBoundInclusive == that.upperBoundInclusive && Objects.equals(this.lowerBound, that.lowerBound) && Objects.equals(this.upperBound, that.upperBound);
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.lowerBoundInclusive, this.upperBound, this.upperBoundInclusive);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.isLowerBoundInclusive() ? (char)'[' : '(');
        if (this.getLowerBound() != null) {
            buf.append(this.getLowerBound().toString());
        }
        buf.append(',');
        if (this.getUpperBound() != null) {
            buf.append(this.getUpperBound().toString());
        }
        buf.append(this.isUpperBoundInclusive() ? (char)']' : ')');
        return buf.toString();
    }
}

