/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import ai.djl.util.Utils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static void unzip(InputStream is, Path dest) throws IOException {
        ZipEntry entry;
        ValidationInputStream vis = new ValidationInputStream(is);
        ZipInputStream zis = new ZipInputStream(vis);
        HashSet<String> set = new HashSet<String>();
        while ((entry = zis.getNextEntry()) != null) {
            String name = ZipUtils.removeLeadingFileSeparator(entry.getName());
            if (name.contains("..")) {
                throw new IOException("Malicious zip entry: " + name);
            }
            set.add(name);
            Path file = dest.resolve(name).toAbsolutePath();
            if (entry.isDirectory()) {
                Files.createDirectories(file, new FileAttribute[0]);
                continue;
            }
            Path parentFile = file.getParent();
            if (parentFile == null) {
                throw new AssertionError((Object)("Parent path should never be null: " + file));
            }
            Files.createDirectories(parentFile, new FileAttribute[0]);
            Files.copy(zis, file, StandardCopyOption.REPLACE_EXISTING);
        }
        try {
            vis.validate(set);
        }
        catch (IOException e) {
            Utils.deleteQuietly(dest);
            throw e;
        }
    }

    public static void zip(Path src, Path dest, boolean includeFolderName) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(dest, new OpenOption[0])));){
            Path root;
            Path path = root = includeFolderName ? src.getParent() : src;
            if (root == null) {
                throw new AssertionError((Object)"Parent folder should not be null.");
            }
            ZipUtils.addToZip(root, src, zos);
        }
    }

    private static void addToZip(Path root, Path file, ZipOutputStream zos) throws IOException {
        Path relative = root.relativize(file);
        String name = relative.toString();
        if (Files.isDirectory(file, new LinkOption[0])) {
            File[] files;
            if (!name.isEmpty()) {
                ZipEntry entry = new ZipEntry(name + '/');
                zos.putNextEntry(entry);
            }
            if ((files = file.toFile().listFiles()) != null) {
                for (File f : files) {
                    ZipUtils.addToZip(root, f.toPath(), zos);
                }
            }
        } else if (Files.isRegularFile(file, new LinkOption[0])) {
            if (name.isEmpty()) {
                name = file.toFile().getName();
            }
            ZipEntry entry = new ZipEntry(name);
            zos.putNextEntry(entry);
            Files.copy(file, zos);
        }
    }

    static String removeLeadingFileSeparator(String name) {
        int index;
        for (index = 0; index < name.length() && name.charAt(index) == File.separatorChar; ++index) {
        }
        return name.substring(index);
    }

    private static final class ValidationInputStream
    extends FilterInputStream {
        private static final int ZIP64_LOCSIG = 117853008;
        private static final int ZIP64_ENDSIG = 101075792;
        private static final int ENDSIG = 101010256;
        private static final int LOCSIG = 67324752;
        private static final int CENSIG = 33639248;
        private static final int ZIP64_LOCHDR = 20;
        private static final int ENDHDR = 22;
        private static final int CENHDR = 46;
        private static final int USE_UTF8 = 2048;
        private byte[] buf = new byte[512];
        private boolean seenCen;
        private long filePosition;

        ValidationInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int read = super.read();
            if (read >= 0 && !this.seenCen) {
                System.arraycopy(this.buf, 1, this.buf, 0, this.buf.length - 1);
                this.buf[this.buf.length - 1] = (byte)read;
            }
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = super.read(b, off, len);
            if (read > 0 && !this.seenCen) {
                if (read < this.buf.length) {
                    System.arraycopy(this.buf, read, this.buf, 0, this.buf.length - read);
                    System.arraycopy(b, off, this.buf, this.buf.length - read, read);
                } else {
                    System.arraycopy(b, off + read - this.buf.length, this.buf, 0, this.buf.length);
                }
                this.filePosition += (long)read;
            }
            return read;
        }

        void validate(Set<String> set) throws IOException {
            this.seenCen = true;
            if (this.filePosition > 0L) {
                int read;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                if (this.filePosition < (long)this.buf.length) {
                    bos.write(this.buf, (int)((long)this.buf.length - this.filePosition), (int)this.filePosition);
                    this.filePosition = 0L;
                } else {
                    bos.write(this.buf);
                    this.filePosition -= (long)this.buf.length;
                }
                byte[] tmp = new byte[512];
                while ((read = this.read(tmp)) != -1) {
                    bos.write(tmp, 0, read);
                }
                bos.close();
                byte[] header = bos.toByteArray();
                List<String> entries = this.initCEN(header);
                for (String name : entries) {
                    if (set.remove(name)) continue;
                    throw new IOException("Malicious zip file, missing file: " + name);
                }
            }
            if (!set.isEmpty()) {
                throw new IOException("Malicious zip file, found hidden " + set.size() + " files.");
            }
        }

        private End findEND(ByteBuffer bb) throws IOException {
            int remaining = bb.remaining();
            if (bb.remaining() == 0) {
                throw new IOException("Zip file is empty");
            }
            End end = new End();
            for (int i = remaining - 22; i >= 0; --i) {
                int cenpos;
                if (bb.getInt(i) != 101010256) continue;
                end.endpos = i;
                end.cenlen = bb.getInt(i + 12);
                end.cenoff = bb.getInt(i + 16);
                short comlen = bb.getShort(i + 20);
                if (end.endpos + 22 + comlen != remaining) {
                    cenpos = end.endpos - end.cenlen;
                    int locpos = Math.toIntExact((long)cenpos - end.cenoff);
                    if (cenpos < 0 || locpos < 0 || bb.getInt(cenpos) != 33639248 || bb.getInt(locpos) != 67324752) continue;
                }
                if ((cenpos = end.endpos - 20) < 0 || bb.getInt(cenpos) != 117853008) {
                    return end;
                }
                long end64pos = bb.getLong(cenpos + 8);
                int relativePos = Math.toIntExact(end64pos - this.filePosition);
                if (relativePos < 0 || bb.getInt(relativePos) != 101075792) {
                    return end;
                }
                int cenlen64 = Math.toIntExact(bb.getLong(relativePos + 40));
                long cenoff64 = bb.getLong(relativePos + 48);
                if (cenlen64 != end.cenlen && end.cenlen > 0 || cenoff64 != end.cenoff && end.cenoff > 0L) {
                    return end;
                }
                end.cenlen = cenlen64;
                end.cenoff = cenoff64;
                end.endpos = relativePos;
                return end;
            }
            throw new IOException("Zip END header not found");
        }

        private List<String> initCEN(byte[] header) throws IOException {
            ByteBuffer bb = ByteBuffer.wrap(header);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            End end = this.findEND(bb);
            if (end.endpos == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> entries = new ArrayList<String>();
            int cenpos = end.endpos - end.cenlen;
            int pos = 0;
            while (pos + 46 <= end.cenlen) {
                if (bb.getInt(cenpos + pos) != 33639248) {
                    throw new IOException("invalid CEN header (bad signature)");
                }
                short nlen = bb.getShort(cenpos + pos + 28);
                short elen = bb.getShort(cenpos + pos + 30);
                short clen = bb.getShort(cenpos + pos + 32);
                short flag = bb.getShort(cenpos + pos + 8);
                if ((flag & 1) != 0) {
                    throw new IOException("invalid CEN header (encrypted entry)");
                }
                Charset charset = (flag & 0x800) != 0 ? StandardCharsets.UTF_8 : StandardCharsets.US_ASCII;
                entries.add(new String(header, cenpos + pos + 46, (int)nlen, charset));
                pos += 46 + nlen + elen + clen;
            }
            if (pos != end.cenlen) {
                throw new IOException("invalid CEN header (bad header size)");
            }
            return entries;
        }

        private static final class End {
            int cenlen;
            long cenoff;
            int endpos;

            private End() {
            }
        }
    }
}

