/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pc.cloud.sdk.utils;

import cn.com.pc.cloud.sdk.common.pojo.dto.DeptInfoDTO;
import cn.com.pc.cloud.sdk.common.pojo.dto.DeptTreeDTO;
import cn.com.pc.cloud.sdk.common.pojo.dto.RankFieldDTO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class DeptUtil {
    private static final Logger log = LoggerFactory.getLogger(DeptUtil.class);

    public static List<DeptInfoDTO> getChild(Long deptId, List<DeptInfoDTO> deptList) {
        ArrayList<DeptInfoDTO> data = new ArrayList<DeptInfoDTO>();
        for (DeptInfoDTO orgDept : deptList) {
            if (!deptId.equals(orgDept.getPid())) continue;
            data.addAll(DeptUtil.getChild(orgDept.getId(), deptList));
            data.add(orgDept);
        }
        return data;
    }

    public static List<DeptInfoDTO> getParentFilter(Long deptId, List<DeptInfoDTO> deptList, List<Long> parentIds) {
        ArrayList<DeptInfoDTO> data = new ArrayList<DeptInfoDTO>();
        for (DeptInfoDTO orgDept : deptList) {
            if (!deptId.equals(orgDept.getId())) continue;
            if (parentIds.contains(orgDept.getPid())) {
                return data;
            }
            data.addAll(DeptUtil.getParentFilter(orgDept.getPid(), deptList, parentIds));
            data.add(orgDept);
        }
        return data;
    }

    public static List<DeptInfoDTO> getParent(Long deptId, List<DeptInfoDTO> deptList) {
        ArrayList<DeptInfoDTO> data = new ArrayList<DeptInfoDTO>();
        for (DeptInfoDTO orgDept : deptList) {
            if (!deptId.equals(orgDept.getId())) continue;
            data.addAll(DeptUtil.getParent(orgDept.getPid(), deptList));
            data.add(orgDept);
        }
        return data;
    }

    public static List<RankFieldDTO> getRankFieldParent(Long deptId, List<RankFieldDTO> deptList) {
        ArrayList<RankFieldDTO> data = new ArrayList<RankFieldDTO>();
        for (RankFieldDTO rankField : deptList) {
            if (!deptId.equals(rankField.getId())) continue;
            data.addAll(DeptUtil.getRankFieldParent(rankField.getPid(), deptList));
            data.add(rankField);
        }
        return data;
    }

    public static List<DeptTreeDTO> bulidTree(List<DeptInfoDTO> menuList) {
        ArrayList<DeptTreeDTO> trees = new ArrayList<DeptTreeDTO>();
        for (DeptInfoDTO treeNode : menuList) {
            if (treeNode.getPid() != null && !treeNode.getPid().equals(0L)) continue;
            DeptTreeDTO result = new DeptTreeDTO();
            BeanUtils.copyProperties((Object)treeNode, (Object)result);
            result.setLevel(1);
            trees.add(DeptUtil.findChildren(result, menuList));
        }
        return trees;
    }

    private static DeptTreeDTO findChildren(DeptTreeDTO treeNode, List<DeptInfoDTO> treeNodes) {
        treeNode.setChildren(new ArrayList<DeptTreeDTO>());
        for (DeptInfoDTO it : treeNodes) {
            if (!treeNode.getId().equals(it.getPid())) continue;
            DeptTreeDTO result = new DeptTreeDTO();
            BeanUtils.copyProperties((Object)it, (Object)result);
            int level = treeNode.getLevel() + 1;
            result.setLevel(level);
            if (treeNode.getChildren() == null) {
                treeNode.setChildren(new ArrayList<DeptTreeDTO>());
            }
            treeNode.getChildren().add(DeptUtil.findChildren(result, treeNodes));
        }
        return treeNode;
    }
}

