/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pc.cloud.sdk.service.impl;

import cn.com.pc.cloud.sdk.common.pojo.dto.DeptInfoDTO;
import cn.com.pc.cloud.sdk.common.pojo.dto.DeptTreeDTO;
import cn.com.pc.cloud.sdk.common.pojo.vo.DeptChainBatchVo;
import cn.com.pc.cloud.sdk.common.pojo.vo.DeptChainVo;
import cn.com.pc.cloud.sdk.common.pojo.vo.DeptGroupVo;
import cn.com.pc.cloud.sdk.common.pojo.vo.DeptTreeVo;
import cn.com.pc.cloud.sdk.common.pojo.vo.DeptTypeVo;
import cn.com.pc.cloud.sdk.mapper.DeptMapper;
import cn.com.pc.cloud.sdk.mapper.UserMapper;
import cn.com.pc.cloud.sdk.service.IDeptService;
import cn.com.pc.cloud.sdk.utils.DeptUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeptServiceImpl
implements IDeptService {
    private static final Logger log = LoggerFactory.getLogger(DeptServiceImpl.class);
    @Autowired
    UserMapper userMapper;
    @Autowired
    DeptMapper deptMapper;

    @Override
    @Nullable
    public List<DeptInfoDTO> getUserDept(Long userId) {
        if (userId == null || userId < 1L) {
            log.warn("getUserCurrentDeptId, userId\u9519\u8bef, userId: {}", (Object)userId);
            return null;
        }
        return this.deptMapper.getUserDept(userId);
    }

    @Override
    @Nullable
    public DeptTreeDTO getDeptTree(Long deptId, Long companyId) {
        List<DeptInfoDTO> allList = this.deptMapper.getCompanyDept(companyId);
        if (allList == null || allList.isEmpty()) {
            return new DeptTreeDTO();
        }
        List<DeptInfoDTO> pList = DeptUtil.getParent(deptId, allList);
        List<DeptInfoDTO> cList = DeptUtil.getChild(deptId, allList);
        pList.addAll(cList);
        if (pList.isEmpty()) {
            return new DeptTreeDTO();
        }
        List<DeptTreeDTO> treeList = DeptUtil.bulidTree(pList);
        return treeList.isEmpty() ? new DeptTreeDTO() : treeList.get(0);
    }

    @Override
    @Nullable
    public List<DeptInfoDTO> getCompanyAllDept(Long companyId) {
        return this.deptMapper.getCompanyDept(companyId);
    }

    @Override
    @Nullable
    public List<DeptInfoDTO> getUserAllDept(Long userId) {
        if (userId == null || userId < 1L) {
            log.warn("getUserDeptTree, userId\u9519\u8bef, userId: {}", (Object)userId);
            return null;
        }
        List<DeptInfoDTO> userRelDeptList = this.deptMapper.getUserAllDept(userId);
        if (CollUtil.isEmpty(userRelDeptList)) {
            log.warn("getUserDeptTree, \u7528\u6237\u6240\u6709\u7ec4\u7ec7\u4e3a\u7a7a, userId: {}", (Object)userId);
            return null;
        }
        Long companyId = userRelDeptList.get(0).getCompanyId();
        List<DeptInfoDTO> allDeptList = this.deptMapper.getCompanyAllDept(companyId);
        ArrayList list = new ArrayList();
        userRelDeptList.forEach(d -> {
            list.add(d);
            list.addAll(DeptUtil.getChild(d.getId(), allDeptList));
        });
        return list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DeptInfoDTO>(Comparator.comparing(DeptInfoDTO::getId))), ArrayList::new));
    }

    @Override
    @Nullable
    public DeptTreeVo getUserDeptTree(Long userId, @Nullable String menuCode) {
        if (userId == null || userId < 1L) {
            log.warn("getUserDeptTree, userId\u9519\u8bef, userId: {}", (Object)userId);
            return null;
        }
        List<DeptInfoDTO> userAllDeptList = this.deptMapper.getUserAllDept(userId);
        if (CollUtil.isEmpty(userAllDeptList)) {
            log.warn("getUserDeptTree, \u7528\u6237\u6240\u6709\u7ec4\u7ec7\u4e3a\u7a7a, userId: {}", (Object)userId);
            return null;
        }
        ArrayList<Long> permDeptList = new ArrayList();
        if (StrUtil.isNotEmpty((CharSequence)menuCode)) {
            permDeptList = this.deptMapper.getUserPermissionDept(userId, menuCode);
        }
        HashMap<Long, List<Long>> idTree = new HashMap<Long, List<Long>>(userAllDeptList.size());
        HashMap<Long, DeptInfoDTO> info = new HashMap<Long, DeptInfoDTO>(userAllDeptList.size());
        userAllDeptList.forEach(d -> {
            idTree.computeIfAbsent(d.getPid(), k -> new ArrayList()).add(d.getId());
            info.put(d.getId(), (DeptInfoDTO)d);
        });
        List<DeptTreeVo> treeVos = this.buildUserChildTree(0L, idTree, info, permDeptList);
        if (treeVos.size() == 1) {
            return treeVos.get(0);
        }
        log.warn("getUserDeptTree, \u9876\u7ea7\u7ec4\u7ec7\u6570\u91cf\u9519\u8bef, userId: {}", (Object)userId);
        return null;
    }

    @Override
    public Set<Long> getUserAllDeptIds(Long userId, @Nullable String menuCode) {
        DeptTreeVo treeVo = this.getUserDeptTree(userId, menuCode);
        if (treeVo == null) {
            return Collections.emptySet();
        }
        HashSet<Long> deptIds = new HashSet<Long>();
        ArrayList<DeptTreeVo> treeVos = ListUtil.of((Object[])new DeptTreeVo[]{treeVo});
        while (CollUtil.isNotEmpty((Collection)treeVos)) {
            ArrayList<DeptTreeVo> newTreeVos = new ArrayList<DeptTreeVo>();
            for (DeptTreeVo vo : treeVos) {
                deptIds.add(vo.getId());
                newTreeVos.addAll(vo.getChildren());
            }
            treeVos = newTreeVos;
        }
        return deptIds;
    }

    @Override
    public Set<Long> getDeptAllDeptIds(List<Long> deptIds) {
        if (CollUtil.isEmpty(deptIds)) {
            log.warn("getDeptAllDeptIds, \u7ec4\u7ec7id\u5217\u8868\u4e3a\u7a7a, deptIds: {}", deptIds);
            return Collections.emptySet();
        }
        List<DeptInfoDTO> batchDeptInfos = this.deptMapper.batchDeptInfos(deptIds);
        if (CollUtil.isEmpty(batchDeptInfos)) {
            log.warn("getDeptAllDeptIds, \u7ec4\u7ec7id\u5217\u8868\u7ec4\u7ec7\u4e0d\u5b58\u5728, deptIds: {}", deptIds);
            return Collections.emptySet();
        }
        List companyIds = batchDeptInfos.stream().map(DeptInfoDTO::getCompanyId).distinct().collect(Collectors.toList());
        if (companyIds.size() != 1) {
            log.warn("getDeptAllDeptIds, \u7ec4\u7ec7id\u5217\u8868\u5bf9\u5e94\u96c6\u56e2id\u4e0d\u4e00\u6837, deptIds: {}, companyId: {}", deptIds, companyIds);
            return Collections.emptySet();
        }
        Long companyId = (Long)companyIds.get(0);
        List<DeptInfoDTO> allDeptList = this.deptMapper.getCompanyAllDept(companyId);
        if (CollUtil.isEmpty(allDeptList)) {
            return Collections.emptySet();
        }
        HashMap p2c = new HashMap(allDeptList.size());
        HashMap c2p = new HashMap(allDeptList.size());
        HashMap infos = new HashMap();
        allDeptList.forEach(d -> {
            p2c.computeIfAbsent(d.getPid(), k -> new ArrayList()).add(d.getId());
            c2p.put(d.getId(), d.getPid());
            infos.put(d.getId(), d);
        });
        HashSet<Long> allDeptIds = new HashSet<Long>();
        for (Long deptId : deptIds) {
            if (!infos.containsKey(deptId)) continue;
            Long parentId = (Long)c2p.get(deptId);
            while (parentId != null && parentId > 0L) {
                allDeptIds.add(parentId);
                parentId = (Long)c2p.get(parentId);
            }
            ArrayList childDeptIds = (ArrayList)p2c.get(deptId);
            while (CollUtil.isNotEmpty((Collection)childDeptIds)) {
                allDeptIds.addAll(childDeptIds);
                ArrayList newChildDeptIds = new ArrayList();
                for (Long childDeptId : childDeptIds) {
                    List cIds = (List)p2c.get(childDeptId);
                    if (cIds == null) continue;
                    newChildDeptIds.addAll(cIds);
                }
                childDeptIds = newChildDeptIds;
            }
        }
        return allDeptIds;
    }

    @Override
    public List<DeptGroupVo> getUserAllDeptGroup(Long userId, String menuCode) {
        DeptTreeVo treeVo = this.getUserDeptTree(userId, menuCode);
        if (treeVo == null) {
            return Collections.emptyList();
        }
        ArrayList<DeptGroupVo> groupVos = new ArrayList<DeptGroupVo>();
        ArrayList<DeptTreeVo> treeVos = ListUtil.of((Object[])new DeptTreeVo[]{treeVo});
        while (CollUtil.isNotEmpty((Collection)treeVos)) {
            ArrayList<DeptTreeVo> newTreeVos = new ArrayList<DeptTreeVo>();
            DeptGroupVo groupVo = DeptGroupVo.builder().level(((DeptTreeVo)treeVos.get(0)).getDeptType().getLevel()).deptIds(new ArrayList<Long>(treeVos.size())).build();
            for (DeptTreeVo vo : treeVos) {
                groupVo.getDeptIds().add(vo.getId());
                newTreeVos.addAll(vo.getChildren());
            }
            groupVos.add(groupVo);
            treeVos = newTreeVos;
        }
        return groupVos;
    }

    @Override
    public List<DeptGroupVo> getDeptAllDeptGroup(List<Long> deptIds) {
        Object childDeptId;
        Long parentId;
        if (CollUtil.isEmpty(deptIds)) {
            log.warn("getDeptAllDeptGroup, \u7ec4\u7ec7id\u5217\u8868\u4e3a\u7a7a, deptIds: {}", deptIds);
            return Collections.emptyList();
        }
        List<DeptInfoDTO> batchDeptInfos = this.deptMapper.batchDeptInfos(deptIds);
        if (CollUtil.isEmpty(batchDeptInfos)) {
            log.warn("getDeptAllDeptGroup, \u7ec4\u7ec7id\u5217\u8868\u7ec4\u7ec7\u4e0d\u5b58\u5728, deptIds: {}", deptIds);
            return Collections.emptyList();
        }
        List companyIds = batchDeptInfos.stream().map(DeptInfoDTO::getCompanyId).distinct().collect(Collectors.toList());
        if (companyIds.size() != 1) {
            log.warn("getDeptAllDeptGroup, \u7ec4\u7ec7id\u5217\u8868\u5bf9\u5e94\u96c6\u56e2id\u4e0d\u4e00\u6837, deptIds: {}, companyId: {}", deptIds, companyIds);
            return Collections.emptyList();
        }
        Long companyId = (Long)companyIds.get(0);
        List<DeptInfoDTO> allDeptList = this.deptMapper.getCompanyAllDept(companyId);
        if (CollUtil.isEmpty(allDeptList)) {
            return Collections.emptyList();
        }
        HashMap p2c = new HashMap(allDeptList.size());
        HashMap c2p = new HashMap(allDeptList.size());
        HashMap infos = new HashMap();
        allDeptList.forEach(d -> {
            p2c.computeIfAbsent(d.getPid(), k -> new ArrayList()).add(d.getId());
            c2p.put(d.getId(), d.getPid());
            infos.put(d.getId(), d);
        });
        HashSet<Long> allDeptIds = new HashSet<Long>();
        for (Long deptId : deptIds) {
            if (!infos.containsKey(deptId)) continue;
            allDeptIds.add(deptId);
            parentId = (Long)c2p.get(deptId);
            while (parentId != null && parentId > 0L) {
                allDeptIds.add(parentId);
                parentId = (Long)c2p.get(parentId);
            }
            Object childDeptIds = (List)p2c.get(deptId);
            while (CollUtil.isNotEmpty((Collection)childDeptIds)) {
                allDeptIds.addAll((Collection<Long>)childDeptIds);
                ArrayList newChildDeptIds = new ArrayList();
                Iterator iterator = childDeptIds.iterator();
                while (iterator.hasNext()) {
                    childDeptId = (Long)iterator.next();
                    List cIds = (List)p2c.get(childDeptId);
                    if (cIds == null) continue;
                    newChildDeptIds.addAll(cIds);
                }
                childDeptIds = newChildDeptIds;
            }
        }
        if (CollUtil.isNotEmpty(allDeptIds)) {
            Iterator it = p2c.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                parentId = (Long)entry.getKey();
                if (parentId != 0L && !allDeptIds.contains(parentId)) {
                    it.remove();
                    continue;
                }
                ((List)entry.getValue()).removeIf(k -> !allDeptIds.contains(k));
            }
        }
        ArrayList<DeptGroupVo> result = new ArrayList<DeptGroupVo>();
        ArrayList childs = (ArrayList)p2c.get(0L);
        while (CollUtil.isNotEmpty((Collection)childs)) {
            ArrayList newChilds = new ArrayList();
            DeptTypeVo deptTypeVo = null;
            for (Long childId : childs) {
                List cids;
                if (deptTypeVo == null) {
                    childDeptId = (DeptInfoDTO)infos.get(childId);
                }
                if (!CollUtil.isNotEmpty((Collection)(cids = (List)p2c.get(childId)))) continue;
                newChilds.addAll(cids);
            }
            DeptGroupVo groupVo = DeptGroupVo.builder().level(deptTypeVo != null ? deptTypeVo.getLevel() : null).deptIds(childs).build();
            result.add(groupVo);
            childs = newChilds;
        }
        return result;
    }

    @Override
    public List<DeptChainVo> getDeptChain(Long deptId) {
        List<DeptChainBatchVo> chainBatchVos = this.getDeptChainBatch(ListUtil.of((Object[])new Long[]{deptId}));
        if (CollUtil.isEmpty(chainBatchVos)) {
            return Collections.emptyList();
        }
        return chainBatchVos.get(0).getChain();
    }

    @Override
    public List<DeptChainBatchVo> getDeptChainBatch(List<Long> deptIds) {
        List<DeptInfoDTO> batchDeptInfos = this.deptMapper.batchDeptInfos(deptIds);
        if (CollUtil.isEmpty(batchDeptInfos)) {
            log.warn("getDeptChainBatch, \u7ec4\u7ec7id\u5217\u8868\u7ec4\u7ec7\u4e0d\u5b58\u5728, deptIds: {}", deptIds);
            return Collections.emptyList();
        }
        List companyIds = batchDeptInfos.stream().map(DeptInfoDTO::getCompanyId).distinct().collect(Collectors.toList());
        if (companyIds.size() != 1) {
            log.warn("getDeptChainBatch, \u7ec4\u7ec7id\u5217\u8868\u5bf9\u5e94\u96c6\u56e2id\u4e0d\u4e00\u6837, deptIds: {}", deptIds);
            return Collections.emptyList();
        }
        Long companyId = (Long)companyIds.get(0);
        List<DeptInfoDTO> allDeptList = this.deptMapper.getCompanyAllDept(companyId);
        if (CollUtil.isEmpty(allDeptList)) {
            return Collections.emptyList();
        }
        HashMap c2p = new HashMap(allDeptList.size());
        HashMap infos = new HashMap();
        allDeptList.forEach(d -> {
            c2p.put(d.getId(), d.getPid());
            infos.put(d.getId(), d);
        });
        ArrayList<DeptChainBatchVo> chainBatchVos = new ArrayList<DeptChainBatchVo>(deptIds.size());
        for (Long deptId : deptIds) {
            if (!infos.containsKey(deptId)) continue;
            ArrayList chainVos = new ArrayList();
            Long parentId = deptId;
            while (parentId != null && parentId > 0L) {
                DeptInfoDTO info = (DeptInfoDTO)infos.get(parentId);
                parentId = (Long)c2p.get(parentId);
            }
            chainBatchVos.add(DeptChainBatchVo.builder().id(deptId).chain(CollUtil.reverse(chainVos)).build());
        }
        return chainBatchVos;
    }

    private List<DeptTreeVo> buildUserChildTree(long deptId, Map<Long, List<Long>> idTree, Map<Long, DeptInfoDTO> info, List<Long> permDeptList) {
        List<Long> childList = idTree.get(deptId);
        if (CollUtil.isEmpty(childList)) {
            return Collections.emptyList();
        }
        ArrayList<DeptTreeVo> treeVoList = new ArrayList<DeptTreeVo>(childList.size());
        for (Long id : childList) {
            boolean last;
            DeptInfoDTO deptInfoDTO = info.get(id);
            if (CollUtil.isNotEmpty(permDeptList) && deptInfoDTO.getIsCurrent() == 1 && !permDeptList.contains(id)) continue;
            DeptTreeVo treeVo = DeptTreeVo.builder().id(id).name(deptInfoDTO.getName()).children(this.buildUserChildTree(id, idTree, info, permDeptList)).build();
            boolean bl = last = deptInfoDTO.getIsCurrent() == 1 && CollUtil.isEmpty(treeVo.getChildren());
            if (!CollUtil.isNotEmpty(treeVo.getChildren()) && !last) continue;
            treeVoList.add(treeVo);
        }
        return treeVoList;
    }
}

