/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pc.recommend.starter.es.common;

public enum ContentType {
    Article("article", "\u6587\u7ae0"),
    Video("video", "\u89c6\u9891"),
    AD("ad", "\u5e7f\u544a"),
    Product("product", "\u4ea7\u54c1"),
    Question("question", "\u95ee\u7b54"),
    Post("post", "\u5e16\u5b50"),
    Audio("audio", "\u97f3\u9891"),
    Course("course", "\u8bfe\u7a0b"),
    ShortMessage("short_message", "\u77ed\u6d88\u606f"),
    Other("other", "\u5176\u5b83");

    private final String name;
    private final String fullname;

    private ContentType(String name, String fullname) {
        this.name = name;
        this.fullname = fullname;
    }

    public static ContentType getSourceByName(String name) {
        for (ContentType contentType : ContentType.values()) {
            if (!contentType.getName().equals(name)) continue;
            return contentType;
        }
        return null;
    }

    public static String getSourceByContainsName(String name) {
        for (ContentType contentType : ContentType.values()) {
            if (!name.contains(contentType.getName())) continue;
            return contentType.toString();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getFullname() {
        return this.fullname;
    }
}

