/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pc.recommend.starter.es.util;

import cn.com.pc.recommend.starter.es.common.TagDayRangeCons;
import cn.com.pc.recommend.starter.es.pojo.InterestScoreTag;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScriptScoreFunctionBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;

public class CommonEsRepositoryUtils {
    private CommonEsRepositoryUtils() {
    }

    static FunctionScoreQueryBuilder getFunctionScoreQueryBuilderType1(BoolQueryBuilder boolQueryBuilder, Set<InterestScoreTag> interestScoreTagSet) {
        ArrayList tagIds = new ArrayList();
        HashMap tagId2WeightMap = new HashMap();
        interestScoreTagSet.forEach(interestScoreTag -> {
            tagIds.add(interestScoreTag.getTagId());
            tagId2WeightMap.put(interestScoreTag.getTagId() + "", interestScoreTag.getAlpha());
        });
        BoolQueryBuilder boolQueryBuilder1 = QueryBuilders.boolQuery();
        if (!tagIds.isEmpty()) {
            boolQueryBuilder1.filter((QueryBuilder)QueryBuilders.termsQuery((String)"tagIds", tagIds));
        }
        String script1 = "double total = 0;List tags=params['_source']['tagIds'];for(int i=0;i<tags.length;i++){if(params.tagId2WeightMap.containsKey(String.valueOf(tags[i]))){total += params.tagId2WeightMap.get(String.valueOf(tags[i]));}} return total;";
        script1 = String.format(script1, "0.1");
        HashMap scriptParam1 = new HashMap();
        scriptParam1.put("tagId2WeightMap", tagId2WeightMap);
        Script scrip = new Script(ScriptType.INLINE, "painless", script1, scriptParam1);
        ScriptScoreFunctionBuilder scriptScoreFunctionBuilder1 = new ScriptScoreFunctionBuilder(scrip);
        FunctionScoreQueryBuilder.FilterFunctionBuilder filterFunctionBuilder1 = new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)boolQueryBuilder1, (ScoreFunctionBuilder)scriptScoreFunctionBuilder1);
        FunctionScoreQueryBuilder.FilterFunctionBuilder[] filterFunctionBuilders = new FunctionScoreQueryBuilder.FilterFunctionBuilder[]{filterFunctionBuilder1};
        FunctionScoreQueryBuilder functionScoreQueryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)boolQueryBuilder, (FunctionScoreQueryBuilder.FilterFunctionBuilder[])filterFunctionBuilders);
        functionScoreQueryBuilder.scoreMode(FunctionScoreQuery.ScoreMode.MULTIPLY);
        functionScoreQueryBuilder.boostMode(CombineFunction.REPLACE);
        return functionScoreQueryBuilder;
    }

    public static FunctionScoreQueryBuilder getFunctionScoreQueryBuilderType2(BoolQueryBuilder boolQueryBuilder) {
        String script1 = "return 1+%s*(doc['weight'].value-%s);";
        HashMap scriptParam1 = Maps.newHashMap();
        script1 = String.format(script1, "0.1", 5);
        Script scrip = new Script(ScriptType.INLINE, "painless", script1, (Map)scriptParam1);
        ScriptScoreFunctionBuilder scriptScoreFunctionBuilder1 = new ScriptScoreFunctionBuilder(scrip);
        FunctionScoreQueryBuilder.FilterFunctionBuilder filterFunctionBuilder1 = new FunctionScoreQueryBuilder.FilterFunctionBuilder((ScoreFunctionBuilder)scriptScoreFunctionBuilder1);
        BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
        boolQueryBuilder2.filter((QueryBuilder)QueryBuilders.existsQuery((String)"metaData.publishDate"));
        boolQueryBuilder2.filter((QueryBuilder)QueryBuilders.existsQuery((String)"statData.pvTotal"));
        String script2 = "long currentTime=params.param1;long offset=params.param2;long pvTotal=doc['statData.pvTotal'].value+1;long publishAt=doc['metaData.publishDate'].value.toInstant().getEpochSecond();long var0=(currentTime-publishAt+offset)/86400;if(var0>0){return pvTotal/Math.pow(var0,%s);}else{return 0;}";
        script2 = String.format(script2, "0.9");
        HashMap<String, Number> scriptParam2 = new HashMap<String, Number>();
        scriptParam2.put("param1", new Date().toInstant().getEpochSecond());
        scriptParam2.put("param2", 28800);
        Script scrip2 = new Script(ScriptType.INLINE, "painless", script2, scriptParam2);
        ScriptScoreFunctionBuilder scriptScoreFunctionBuilder2 = new ScriptScoreFunctionBuilder(scrip2);
        FunctionScoreQueryBuilder.FilterFunctionBuilder filterFunctionBuilder2 = new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)boolQueryBuilder2, (ScoreFunctionBuilder)scriptScoreFunctionBuilder2);
        FunctionScoreQueryBuilder.FilterFunctionBuilder[] filterFunctionBuilders = new FunctionScoreQueryBuilder.FilterFunctionBuilder[]{filterFunctionBuilder1, filterFunctionBuilder2};
        FunctionScoreQueryBuilder functionScoreQueryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)boolQueryBuilder, (FunctionScoreQueryBuilder.FilterFunctionBuilder[])filterFunctionBuilders);
        functionScoreQueryBuilder.scoreMode(FunctionScoreQuery.ScoreMode.MULTIPLY);
        functionScoreQueryBuilder.boostMode(CombineFunction.REPLACE);
        return functionScoreQueryBuilder;
    }

    public static void metadataPublishatRangequery(BoolQueryBuilder boolQueryBuilder, boolean priority) {
        if (priority) {
            TagDayRangeCons.Priority.dayRangeList.forEach(dayRange -> {
                TermsQueryBuilder termsQueryBuilder = QueryBuilders.termsQuery((String)"tagIds", dayRange.getTagIds());
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"metaData.publishDate").timeZone("Asia/Shanghai").lt((Object)dayRange.getDayRange()).format("yyyy-MM-dd HH:mm:ss");
                BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
                queryBuilder.filter().addAll(Lists.newArrayList((Object[])new AbstractQueryBuilder[]{termsQueryBuilder, rangeQueryBuilder}));
                boolQueryBuilder.mustNot((QueryBuilder)queryBuilder);
            });
        } else {
            TagDayRangeCons.Secondary.dayRangeList.forEach(dayRange -> {
                TermsQueryBuilder termsQueryBuilder = QueryBuilders.termsQuery((String)"tagIds", dayRange.getTagIds());
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"metaData.publishDate").timeZone("Asia/Shanghai").lt((Object)dayRange.getDayRange()).format("yyyy-MM-dd HH:mm:ss");
                BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
                queryBuilder.filter().addAll(Lists.newArrayList((Object[])new AbstractQueryBuilder[]{termsQueryBuilder, rangeQueryBuilder}));
                boolQueryBuilder.mustNot((QueryBuilder)queryBuilder);
            });
        }
        boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.rangeQuery((String)"metaData.publishDate").timeZone("Asia/Shanghai").gt((Object)"now/d").format("yyyy-MM-dd HH:mm:ss"));
    }

    public static void processInterestTagIds(Set<Integer> realTimeTagIds3) {
        realTimeTagIds3.removeIf(next -> next < 100000);
    }

    public static void participateInScoreTagIds(BoolQueryBuilder boolQueryBuilder, Set<Integer> tagIds) {
        if (tagIds.isEmpty()) {
            return;
        }
        for (Integer tagId : tagIds) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"tagIds", (Collection)Lists.newArrayList((Object[])new Integer[]{tagId})));
        }
    }
}

