/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pc.recommend.starter.es.repository;

import cn.com.pc.recommend.starter.es.common.RecallCommonParam;
import cn.com.pc.recommend.starter.es.pojo.DmpInParam;
import cn.com.pc.recommend.starter.es.util.CommonEsRepositoryUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.stereotype.Repository;

@Repository
public class PcpPconlineVideoRepository {
    public SearchRequest getSearchRequest(DmpInParam dmpInParam) {
        String index = "pcp_pconline_video";
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder source = searchRequest.source();
        source.from(dmpInParam.getFrom());
        source.size(dmpInParam.getSize());
        source.trackTotalHits(true);
        dmpInParam.getSortFields().forEach(sortField -> source.sort(sortField.getField(), sortField.getSortOrder()));
        source.trackScores(true);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!dmpInParam.getExcludeContentIds().isEmpty()) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"id", dmpInParam.getExcludeContentIds()));
        }
        boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"weight", (String[])RecallCommonParam.MUST_NOT_WEIGHT));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"auditStatus", (String[])RecallCommonParam.MUST_AUDIT_STATUS));
        switch (dmpInParam.getRecallId()) {
            case 5: {
                source.size(dmpInParam.getSize() * 2);
                CommonEsRepositoryUtils.metadataPublishatRangequery(boolQueryBuilder, false);
                searchRequest.indices(new String[]{"pcp_pconline_video"});
                FunctionScoreQueryBuilder functionScoreQueryBuilder5 = CommonEsRepositoryUtils.getFunctionScoreQueryBuilderType2(boolQueryBuilder);
                source.query((QueryBuilder)functionScoreQueryBuilder5);
                break;
            }
            case 6: {
                source.size(dmpInParam.getSize() * 2);
                searchRequest.indices(new String[]{"pcp_pconline_video"});
                RangeQueryBuilder videoPublishAt = QueryBuilders.rangeQuery((String)"metaData.publishDate").timeZone("Asia/Shanghai").gt((Object)"now-1d/d").format("yyyy-MM-dd HH:mm:ss");
                boolQueryBuilder.filter((QueryBuilder)videoPublishAt);
                source.query((QueryBuilder)boolQueryBuilder);
                return searchRequest;
            }
        }
        return searchRequest;
    }
}

