/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pc.recommend.starter.es.service.impl;

import cn.com.pc.recommend.starter.es.common.ContentType;
import cn.com.pc.recommend.starter.es.common.RecallIdEnum;
import cn.com.pc.recommend.starter.es.pojo.DmpInParam;
import cn.com.pc.recommend.starter.es.pojo.RecallResult;
import cn.com.pc.recommend.starter.es.pojo.RecallResultList;
import cn.com.pc.recommend.starter.es.repository.PcpPconlineArticleRepository;
import cn.com.pc.recommend.starter.es.repository.PcpPconlineVideoRepository;
import cn.com.pc.recommend.starter.es.service.MultiSearchRecallService;
import cn.com.pc.recommend.starter.es.util.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MultiSearchRecallServiceImpl
implements MultiSearchRecallService {
    private static final Logger log = LoggerFactory.getLogger(MultiSearchRecallServiceImpl.class);
    @Autowired
    private PcpPconlineArticleRepository pcpPconlineArticleRepository;
    @Autowired
    private PcpPconlineVideoRepository pcpPconlineVideoRepository;
    @Autowired
    private RestHighLevelClient restHighLevelClient;

    @Override
    public RecallResultList multiSearchRecallForDmp(DmpInParam dmpInParam) {
        MultiSearchRequest request = this.getMultiSearchRequest(dmpInParam);
        try {
            MultiSearchResponse response = this.restHighLevelClient.msearch(request, RequestOptions.DEFAULT);
            return this.getSourceAsMapList(response);
        }
        catch (IOException e) {
            log.error(e.toString());
            return new RecallResultList();
        }
    }

    private MultiSearchRequest getMultiSearchRequest(DmpInParam dmpInParam) {
        MultiSearchRequest request = new MultiSearchRequest();
        dmpInParam.setRecallId(RecallIdEnum.hotArticle.getId());
        SearchRequest hotArticleSearchRequest = this.pcpPconlineArticleRepository.getSearchRequest(dmpInParam);
        request.add(hotArticleSearchRequest);
        dmpInParam.setRecallId(RecallIdEnum.realTimeArticle.getId());
        SearchRequest realTimeArticleSearchRequest = this.pcpPconlineArticleRepository.getSearchRequest(dmpInParam);
        request.add(realTimeArticleSearchRequest);
        dmpInParam.setRecallId(RecallIdEnum.longTermArticle.getId());
        SearchRequest longTermArticleSearchRequest = this.pcpPconlineArticleRepository.getSearchRequest(dmpInParam);
        request.add(longTermArticleSearchRequest);
        dmpInParam.setRecallId(RecallIdEnum.newPostArticle.getId());
        SearchRequest newPostArticleSearchRequest = this.pcpPconlineArticleRepository.getSearchRequest(dmpInParam);
        request.add(newPostArticleSearchRequest);
        dmpInParam.setRecallId(RecallIdEnum.interrestHotVideo.getId());
        SearchRequest interrestHotVideoSearchRequest = this.pcpPconlineVideoRepository.getSearchRequest(dmpInParam);
        request.add(interrestHotVideoSearchRequest);
        dmpInParam.setRecallId(RecallIdEnum.newPostVideo.getId());
        SearchRequest newPostVideoSearchRequest = this.pcpPconlineVideoRepository.getSearchRequest(dmpInParam);
        request.add(newPostVideoSearchRequest);
        return request;
    }

    private RecallResultList getSourceAsMapList(MultiSearchResponse response) {
        RecallResultList result = new RecallResultList();
        block8: for (int i = 0; i < 6; ++i) {
            MultiSearchResponse.Item item = response.getResponses()[i];
            if (null == item) continue;
            SearchResponse searchResponse = item.getResponse();
            if (null == searchResponse) {
                if (null == item.getFailure()) continue;
                log.error(item.getFailure().toString());
                continue;
            }
            ArrayList<RecallResult> recommendResults = new ArrayList<RecallResult>();
            for (SearchHit hit : searchResponse.getHits()) {
                RecallResult recallResult2 = JsonUtils.jsonToObj(hit.getSourceAsString(), RecallResult.class);
                recallResult2.setScore(Float.valueOf(hit.getScore()));
                recommendResults.add(recallResult2);
            }
            switch (i) {
                case 0: {
                    recommendResults.forEach(recallResult -> {
                        recallResult.setRecallId(RecallIdEnum.hotArticle.getId());
                        recallResult.setContentType(ContentType.Article.getName());
                    });
                    result.setHotArticle(recommendResults);
                    continue block8;
                }
                case 1: {
                    recommendResults.forEach(recallResult -> {
                        recallResult.setRecallId(RecallIdEnum.realTimeArticle.getId());
                        recallResult.setContentType(ContentType.Article.getName());
                    });
                    result.setRealTimeArticle(recommendResults);
                    continue block8;
                }
                case 2: {
                    recommendResults.forEach(recallResult -> {
                        recallResult.setRecallId(RecallIdEnum.longTermArticle.getId());
                        recallResult.setContentType(ContentType.Article.getName());
                    });
                    result.setLongTermArticle(recommendResults);
                    continue block8;
                }
                case 3: {
                    recommendResults.forEach(recallResult -> {
                        recallResult.setRecallId(RecallIdEnum.newPostArticle.getId());
                        recallResult.setContentType(ContentType.Article.getName());
                    });
                    result.setNewPostArticle(recommendResults);
                    continue block8;
                }
                case 4: {
                    recommendResults.forEach(recallResult -> {
                        recallResult.setRecallId(RecallIdEnum.interrestHotVideo.getId());
                        recallResult.setContentType(ContentType.Video.getName());
                    });
                    result.setInterrestHotVideo(recommendResults);
                    continue block8;
                }
                case 5: {
                    recommendResults.forEach(recallResult -> {
                        recallResult.setRecallId(RecallIdEnum.newPostVideo.getId());
                        recallResult.setContentType(ContentType.Video.getName());
                    });
                    result.setNewPostVideo(recommendResults);
                    continue block8;
                }
            }
        }
        return result;
    }
}

