/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pc.recommend.starter.es.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    private static ObjectMapper mapper = new ObjectMapper();

    public static <T> String obj2String(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> String obj2StringPretty(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T jsonToObj(String str, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)str) || clazz == null) {
            return null;
        }
        try {
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (T)(clazz.equals(String.class) ? str : mapper.readValue(str, clazz));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T jsonToObj(String str, TypeReference<T> typeReference) {
        if (StringUtils.isBlank((CharSequence)str) || typeReference == null) {
            return null;
        }
        try {
            return (T)(typeReference.getType().equals(String.class) ? str : mapper.readValue(str, typeReference));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static <T> T string2Obj(String str, Class<?> collectionClazz, Class<?> ... elementClazzes) {
        JavaType javaType = mapper.getTypeFactory().constructParametricType(collectionClazz, (Class[])elementClazzes);
        try {
            return (T)mapper.readValue(str, javaType);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static <T> JsonNode obj2JsonNode(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return mapper.readTree(JsonUtils.obj2String(obj));
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    static {
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }
}

