/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pc.recommend.starter.es.repository;

import cn.com.pc.recommend.starter.es.common.RecallCommonParam;
import cn.com.pc.recommend.starter.es.pojo.DmpInParam;
import cn.com.pc.recommend.starter.es.pojo.InterestScoreTag;
import cn.com.pc.recommend.starter.es.util.CommonEsRepositoryUtils;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.stereotype.Repository;

@Repository
public class PcpPconlineArticleRepository {
    public SearchRequest getSearchRequest(DmpInParam dmpInParam) {
        String index = "pcp_pconline_article";
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder source = searchRequest.source();
        source.from(dmpInParam.getFrom());
        source.size(dmpInParam.getSize());
        source.trackTotalHits(true);
        dmpInParam.getSortFields().forEach(sortField -> source.sort(sortField.getField(), sortField.getSortOrder()));
        source.trackScores(true);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!dmpInParam.getExcludeContentIds().isEmpty()) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"id", dmpInParam.getExcludeContentIds()));
        }
        boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"weight", (String[])RecallCommonParam.MUST_NOT_WEIGHT));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"auditStatus", (String[])RecallCommonParam.MUST_AUDIT_STATUS));
        switch (dmpInParam.getRecallId()) {
            case 1: {
                CommonEsRepositoryUtils.metadataPublishatRangequery(boolQueryBuilder, false);
                source.size(dmpInParam.getSize() * 4);
                FunctionScoreQueryBuilder functionScoreQueryBuilder = CommonEsRepositoryUtils.getFunctionScoreQueryBuilderType2(boolQueryBuilder);
                source.query((QueryBuilder)functionScoreQueryBuilder);
                break;
            }
            case 2: {
                CommonEsRepositoryUtils.metadataPublishatRangequery(boolQueryBuilder, true);
                source.size(dmpInParam.getSize() * 4);
                Set<Integer> realTimeTagIds = dmpInParam.getRealTimeInterestScoreTags().stream().map(InterestScoreTag::getTagId).collect(Collectors.toSet());
                if (!realTimeTagIds.isEmpty()) {
                    CommonEsRepositoryUtils.processInterestTagIds(realTimeTagIds);
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"tagIds", realTimeTagIds));
                    CommonEsRepositoryUtils.participateInScoreTagIds(boolQueryBuilder, realTimeTagIds);
                } else {
                    source.query((QueryBuilder)QueryBuilders.termsQuery((String)"weight", (String[])RecallCommonParam.MUST_NOT_EXIT_WEIGHT));
                }
                source.query((QueryBuilder)boolQueryBuilder);
                break;
            }
            case 3: {
                CommonEsRepositoryUtils.metadataPublishatRangequery(boolQueryBuilder, true);
                source.size(dmpInParam.getSize() * 4);
                Set<Integer> longTimeTagIds = dmpInParam.getLongTimeInterestScoreTags().stream().map(InterestScoreTag::getTagId).collect(Collectors.toSet());
                if (!longTimeTagIds.isEmpty()) {
                    CommonEsRepositoryUtils.processInterestTagIds(longTimeTagIds);
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"tagIds", longTimeTagIds));
                    CommonEsRepositoryUtils.participateInScoreTagIds(boolQueryBuilder, longTimeTagIds);
                } else {
                    source.query((QueryBuilder)QueryBuilders.termsQuery((String)"weight", (String[])RecallCommonParam.MUST_NOT_EXIT_WEIGHT));
                }
                source.query((QueryBuilder)boolQueryBuilder);
                break;
            }
            case 4: {
                source.size(dmpInParam.getSize() * 2);
                RangeQueryBuilder articlePublishAt = QueryBuilders.rangeQuery((String)"metaData.publishDate").timeZone("Asia/Shanghai").gt((Object)"now-1d/d").format("yyyy-MM-dd HH:mm:ss");
                boolQueryBuilder.filter((QueryBuilder)articlePublishAt);
                source.query((QueryBuilder)boolQueryBuilder);
                return searchRequest;
            }
        }
        return searchRequest;
    }
}

