/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pc.recommend.starter.es.config;

import cn.com.pc.recommend.starter.es.config.ElasticSearchProperties;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="elasticSearchConfig")
public class ElasticSearchConfig {
    private static final int ADDRESS_LENGTH = 2;
    private static final String HTTP_SCHEME = "http";
    @Resource
    private ElasticSearchProperties elasticSearchProperties;

    @Bean
    public RestClientBuilder restClientBuilder() {
        HttpHost[] hosts = (HttpHost[])Arrays.stream(this.elasticSearchProperties.getIpAddress()).map(this::makeHttpHost).filter(Objects::nonNull).toArray(HttpHost[]::new);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.elasticSearchProperties.getUsername(), this.elasticSearchProperties.getPassword()));
        return RestClient.builder((HttpHost[])hosts).setHttpClientConfigCallback(arg_0 -> ElasticSearchConfig.lambda$restClientBuilder$1((CredentialsProvider)credentialsProvider, arg_0));
    }

    @Bean(name={"restHighLevelClient"})
    public RestHighLevelClient restHighLevelClient(@Autowired RestClientBuilder restClientBuilder) {
        return new RestHighLevelClient(restClientBuilder);
    }

    private HttpHost makeHttpHost(String s) {
        assert (StringUtils.isNotEmpty((CharSequence)s));
        String[] address = s.split(":");
        if (address.length == 2) {
            String ip = address[0];
            int port = Integer.parseInt(address[1]);
            return new HttpHost(ip, port, HTTP_SCHEME);
        }
        return null;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$restClientBuilder$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder callback) {
        return callback.setDefaultCredentialsProvider(credentialsProvider);
    }
}

