/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pc.recommend.starter.es.repository;

import cn.com.pc.recommend.starter.es.config.TagMaxPercentConfig;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TreeNameRepository {
    private static final Logger log = LoggerFactory.getLogger(TreeNameRepository.class);
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    private TagMaxPercentConfig tagMaxPercentConfig;

    public Map<String, Integer> getTreeName(Map<String, List<String>> treeNameCache, int resultNum) {
        HashMap result = Maps.newHashMap();
        TagMaxPercentConfig.Item levelOne = this.tagMaxPercentConfig.getLevelOne();
        treeNameCache.getOrDefault("LevelOne", Lists.newArrayList()).forEach(tagId -> result.put(tagId, (int)Math.ceil(levelOne.getPercent() * (double)resultNum)));
        TagMaxPercentConfig.Item levelTwo = this.tagMaxPercentConfig.getLevelTwo();
        treeNameCache.getOrDefault("LevelTwo", Lists.newArrayList()).forEach(tagId -> result.put(tagId, (int)Math.ceil(levelOne.getPercent() * (double)resultNum)));
        return result;
    }

    public Map<String, List<String>> getTreeNameCache() {
        log.warn("\u91cd\u65b0\u8bfb\u53d6\u4e00\u7ea7\u4e8c\u7ea7\u4e3b\u9898\u6807\u7b7e");
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        MultiSearchResponse msearch = null;
        try {
            msearch = this.restHighLevelClient.msearch(this.createMultiSearchRequest(), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.info("{}", (Object)e.toString());
        }
        if (null != msearch) {
            block10: for (int i = 0; i < 2; ++i) {
                MultiSearchResponse.Item item = msearch.getResponses()[i];
                if (null == item) continue;
                ArrayList tagids = Lists.newArrayList();
                SearchResponse searchResponse = item.getResponse();
                for (SearchHit hit : searchResponse.getHits()) {
                    Map sourceAsMap = hit.getSourceAsMap();
                    Integer id = (Integer)sourceAsMap.get("id");
                    switch (i) {
                        case 0: {
                            tagids.add(String.valueOf(id));
                            break;
                        }
                        case 1: {
                            tagids.add(String.valueOf(id));
                            break;
                        }
                    }
                }
                switch (i) {
                    case 0: {
                        map.put("LevelOne", tagids);
                        continue block10;
                    }
                    case 1: {
                        map.put("LevelTwo", tagids);
                        continue block10;
                    }
                }
            }
        }
        return map;
    }

    private MultiSearchRequest createMultiSearchRequest() {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        SearchRequest searchRequest = new SearchRequest(new String[]{"pcp_tags"});
        SearchSourceBuilder source = searchRequest.source();
        source.query((QueryBuilder)QueryBuilders.termsQuery((String)"treeName.keyword", (String[])new String[]{"\u4e3b\u9898\u4e00\u7ea7"}));
        source.fetchSource(new String[]{"id"}, null);
        multiSearchRequest.add(searchRequest);
        SearchRequest searchRequest2 = new SearchRequest(new String[]{"pcp_tags"});
        SearchSourceBuilder source2 = searchRequest2.source();
        source2.query((QueryBuilder)QueryBuilders.termsQuery((String)"treeName.keyword", (String[])new String[]{"\u4e3b\u9898\u4e8c\u7ea7"}));
        source.fetchSource(new String[]{"id"}, null);
        multiSearchRequest.add(searchRequest2);
        return multiSearchRequest;
    }
}

