/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pc.recommend.starter.es.base;

import cn.com.pc.recommend.starter.es.base.BaseQueryParam;
import java.util.Collection;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public abstract class BaseRepository {
    public SearchRequest getBaseSearchRequest(BaseQueryParam baseQueryParam) {
        SearchRequest searchRequest = new SearchRequest(baseQueryParam.getIndex());
        SearchSourceBuilder source = searchRequest.source();
        source.from(baseQueryParam.getFrom());
        source.size(baseQueryParam.getSize());
        source.trackTotalHits(baseQueryParam.getTrackTotalHits().booleanValue());
        baseQueryParam.getSortFields().forEach(sortField -> source.sort(sortField.getField(), sortField.getSortOrder()));
        source.trackScores(baseQueryParam.getTrackScores().booleanValue());
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        baseQueryParam.getMustMap().keySet().forEach(key -> boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)((String)key), (Collection)baseQueryParam.getMustMap().get(key))));
        baseQueryParam.getMustNotMap().keySet().forEach(key -> boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)((String)key), (Collection)baseQueryParam.getMustNotMap().get(key))));
        baseQueryParam.getShouldMap().keySet().forEach(key -> boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)((String)key), (Collection)baseQueryParam.getShouldMap().get(key))));
        source.query((QueryBuilder)boolQueryBuilder);
        return searchRequest;
    }

    public abstract SearchRequest getSearchRequest(BaseQueryParam var1);

    public abstract SearchResponse getSearchResponse(SearchRequest var1);
}

