/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pc.recommend.starter.es.expand;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.search.lookup.SearchLookup;

public class MyExpertScriptEngine
implements ScriptEngine {
    public String getType() {
        return "type1_scripts";
    }

    public <T> T compile(String scriptName, String scriptSource, ScriptContext<T> context, Map<String, String> params) {
        if (!context.equals((Object)ScoreScript.CONTEXT)) {
            throw new IllegalArgumentException(this.getType() + " scripts cannot be used for context [" + context.name + "]");
        }
        if ("pure_df".equals(scriptSource)) {
            ScoreScript.Factory factory = (x$0, x$1) -> new PureDfLeafFactory(x$0, x$1);
            return context.factoryClazz.cast(factory);
        }
        throw new IllegalArgumentException("Unknown script name " + scriptSource);
    }

    public void close() {
    }

    private static class PureDfLeafFactory
    implements ScoreScript.LeafFactory {
        private final Map<String, Object> params;
        private final SearchLookup lookup;
        private final String field;
        private final String term;

        private PureDfLeafFactory(Map<String, Object> params, SearchLookup lookup) {
            if (!params.containsKey("field")) {
                throw new IllegalArgumentException("Missing parameter [field]");
            }
            if (!params.containsKey("term")) {
                throw new IllegalArgumentException("Missing parameter [term]");
            }
            this.params = params;
            this.lookup = lookup;
            this.field = params.get("field").toString();
            this.term = params.get("term").toString();
        }

        public boolean needs_score() {
            return false;
        }

        public ScoreScript newInstance(LeafReaderContext context) throws IOException {
            final PostingsEnum postings = context.reader().postings(new Term(this.field, this.term));
            if (postings == null) {
                return new ScoreScript(this.params, this.lookup, context){

                    public double execute(ScoreScript.ExplanationHolder explanationHolder) {
                        return 0.0;
                    }
                };
            }
            return new ScoreScript(this.params, this.lookup, context){
                int currentDocid;
                {
                    super(x0, x1, x2);
                    this.currentDocid = -1;
                }

                public double execute(ScoreScript.ExplanationHolder explanationHolder) {
                    return 0.0;
                }

                public void setDocument(int docid) {
                    if (postings.docID() < docid) {
                        try {
                            postings.advance(docid);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    this.currentDocid = docid;
                }
            };
        }
    }
}

