/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pc.recommend.starter.es.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(value="tagMaxPercentConfig")
@ConfigurationProperties(prefix="tag.max-percent")
public class TagMaxPercentConfig {
    private Item news;
    private Item baoliao;
    private Item zatan;
    private Item pingce;
    private Item guanshang;
    private Item kepu;
    private Item daogou;
    private Item zhongcao;
    private Item other;
    private Item levelOne;
    private Item levelTwo;
    private Item category;
    private Item brand;
    private Item model;

    public List<Item> getItems() {
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(Optional.ofNullable(this.news).orElse(new Item()));
        items.add(Optional.ofNullable(this.baoliao).orElse(new Item()));
        items.add(Optional.ofNullable(this.zatan).orElse(new Item()));
        items.add(Optional.ofNullable(this.pingce).orElse(new Item()));
        items.add(Optional.ofNullable(this.guanshang).orElse(new Item()));
        items.add(Optional.ofNullable(this.kepu).orElse(new Item()));
        items.add(Optional.ofNullable(this.daogou).orElse(new Item()));
        items.add(Optional.ofNullable(this.zhongcao).orElse(new Item()));
        items.add(Optional.ofNullable(this.other).orElse(new Item()));
        items.add(Optional.ofNullable(this.levelOne).orElse(new Item()));
        items.add(Optional.ofNullable(this.levelTwo).orElse(new Item()));
        items.add(Optional.ofNullable(this.category).orElse(new Item()));
        items.add(Optional.ofNullable(this.brand).orElse(new Item()));
        items.add(Optional.ofNullable(this.model).orElse(new Item()));
        return items;
    }

    public Map<String, Integer> getTag2NumMap(int resultNum) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        this.getItems().forEach(item -> item.getTagIds().forEach(s -> map.put((String)s, Double.valueOf(Math.ceil((double)resultNum * item.getPercent())).intValue())));
        return map;
    }

    public Item getNews() {
        return this.news;
    }

    public Item getBaoliao() {
        return this.baoliao;
    }

    public Item getZatan() {
        return this.zatan;
    }

    public Item getPingce() {
        return this.pingce;
    }

    public Item getGuanshang() {
        return this.guanshang;
    }

    public Item getKepu() {
        return this.kepu;
    }

    public Item getDaogou() {
        return this.daogou;
    }

    public Item getZhongcao() {
        return this.zhongcao;
    }

    public Item getOther() {
        return this.other;
    }

    public Item getLevelOne() {
        return this.levelOne;
    }

    public Item getLevelTwo() {
        return this.levelTwo;
    }

    public Item getCategory() {
        return this.category;
    }

    public Item getBrand() {
        return this.brand;
    }

    public Item getModel() {
        return this.model;
    }

    public void setNews(Item news) {
        this.news = news;
    }

    public void setBaoliao(Item baoliao) {
        this.baoliao = baoliao;
    }

    public void setZatan(Item zatan) {
        this.zatan = zatan;
    }

    public void setPingce(Item pingce) {
        this.pingce = pingce;
    }

    public void setGuanshang(Item guanshang) {
        this.guanshang = guanshang;
    }

    public void setKepu(Item kepu) {
        this.kepu = kepu;
    }

    public void setDaogou(Item daogou) {
        this.daogou = daogou;
    }

    public void setZhongcao(Item zhongcao) {
        this.zhongcao = zhongcao;
    }

    public void setOther(Item other) {
        this.other = other;
    }

    public void setLevelOne(Item levelOne) {
        this.levelOne = levelOne;
    }

    public void setLevelTwo(Item levelTwo) {
        this.levelTwo = levelTwo;
    }

    public void setCategory(Item category) {
        this.category = category;
    }

    public void setBrand(Item brand) {
        this.brand = brand;
    }

    public void setModel(Item model) {
        this.model = model;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagMaxPercentConfig)) {
            return false;
        }
        TagMaxPercentConfig other = (TagMaxPercentConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Item this$news = this.getNews();
        Item other$news = other.getNews();
        if (this$news == null ? other$news != null : !((Object)this$news).equals(other$news)) {
            return false;
        }
        Item this$baoliao = this.getBaoliao();
        Item other$baoliao = other.getBaoliao();
        if (this$baoliao == null ? other$baoliao != null : !((Object)this$baoliao).equals(other$baoliao)) {
            return false;
        }
        Item this$zatan = this.getZatan();
        Item other$zatan = other.getZatan();
        if (this$zatan == null ? other$zatan != null : !((Object)this$zatan).equals(other$zatan)) {
            return false;
        }
        Item this$pingce = this.getPingce();
        Item other$pingce = other.getPingce();
        if (this$pingce == null ? other$pingce != null : !((Object)this$pingce).equals(other$pingce)) {
            return false;
        }
        Item this$guanshang = this.getGuanshang();
        Item other$guanshang = other.getGuanshang();
        if (this$guanshang == null ? other$guanshang != null : !((Object)this$guanshang).equals(other$guanshang)) {
            return false;
        }
        Item this$kepu = this.getKepu();
        Item other$kepu = other.getKepu();
        if (this$kepu == null ? other$kepu != null : !((Object)this$kepu).equals(other$kepu)) {
            return false;
        }
        Item this$daogou = this.getDaogou();
        Item other$daogou = other.getDaogou();
        if (this$daogou == null ? other$daogou != null : !((Object)this$daogou).equals(other$daogou)) {
            return false;
        }
        Item this$zhongcao = this.getZhongcao();
        Item other$zhongcao = other.getZhongcao();
        if (this$zhongcao == null ? other$zhongcao != null : !((Object)this$zhongcao).equals(other$zhongcao)) {
            return false;
        }
        Item this$other = this.getOther();
        Item other$other = other.getOther();
        if (this$other == null ? other$other != null : !((Object)this$other).equals(other$other)) {
            return false;
        }
        Item this$levelOne = this.getLevelOne();
        Item other$levelOne = other.getLevelOne();
        if (this$levelOne == null ? other$levelOne != null : !((Object)this$levelOne).equals(other$levelOne)) {
            return false;
        }
        Item this$levelTwo = this.getLevelTwo();
        Item other$levelTwo = other.getLevelTwo();
        if (this$levelTwo == null ? other$levelTwo != null : !((Object)this$levelTwo).equals(other$levelTwo)) {
            return false;
        }
        Item this$category = this.getCategory();
        Item other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)this$category).equals(other$category)) {
            return false;
        }
        Item this$brand = this.getBrand();
        Item other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !((Object)this$brand).equals(other$brand)) {
            return false;
        }
        Item this$model = this.getModel();
        Item other$model = other.getModel();
        return !(this$model == null ? other$model != null : !((Object)this$model).equals(other$model));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TagMaxPercentConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Item $news = this.getNews();
        result = result * 59 + ($news == null ? 43 : ((Object)$news).hashCode());
        Item $baoliao = this.getBaoliao();
        result = result * 59 + ($baoliao == null ? 43 : ((Object)$baoliao).hashCode());
        Item $zatan = this.getZatan();
        result = result * 59 + ($zatan == null ? 43 : ((Object)$zatan).hashCode());
        Item $pingce = this.getPingce();
        result = result * 59 + ($pingce == null ? 43 : ((Object)$pingce).hashCode());
        Item $guanshang = this.getGuanshang();
        result = result * 59 + ($guanshang == null ? 43 : ((Object)$guanshang).hashCode());
        Item $kepu = this.getKepu();
        result = result * 59 + ($kepu == null ? 43 : ((Object)$kepu).hashCode());
        Item $daogou = this.getDaogou();
        result = result * 59 + ($daogou == null ? 43 : ((Object)$daogou).hashCode());
        Item $zhongcao = this.getZhongcao();
        result = result * 59 + ($zhongcao == null ? 43 : ((Object)$zhongcao).hashCode());
        Item $other = this.getOther();
        result = result * 59 + ($other == null ? 43 : ((Object)$other).hashCode());
        Item $levelOne = this.getLevelOne();
        result = result * 59 + ($levelOne == null ? 43 : ((Object)$levelOne).hashCode());
        Item $levelTwo = this.getLevelTwo();
        result = result * 59 + ($levelTwo == null ? 43 : ((Object)$levelTwo).hashCode());
        Item $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)$category).hashCode());
        Item $brand = this.getBrand();
        result = result * 59 + ($brand == null ? 43 : ((Object)$brand).hashCode());
        Item $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : ((Object)$model).hashCode());
        return result;
    }

    public String toString() {
        return "TagMaxPercentConfig(news=" + this.getNews() + ", baoliao=" + this.getBaoliao() + ", zatan=" + this.getZatan() + ", pingce=" + this.getPingce() + ", guanshang=" + this.getGuanshang() + ", kepu=" + this.getKepu() + ", daogou=" + this.getDaogou() + ", zhongcao=" + this.getZhongcao() + ", other=" + this.getOther() + ", levelOne=" + this.getLevelOne() + ", levelTwo=" + this.getLevelTwo() + ", category=" + this.getCategory() + ", brand=" + this.getBrand() + ", model=" + this.getModel() + ")";
    }

    public static class Item {
        private Set<String> tagIds;
        private double percent;

        public Set<String> getTagIds() {
            return this.tagIds;
        }

        public double getPercent() {
            return this.percent;
        }

        public void setTagIds(Set<String> tagIds) {
            this.tagIds = tagIds;
        }

        public void setPercent(double percent) {
            this.percent = percent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getPercent(), other.getPercent()) != 0) {
                return false;
            }
            Set<String> this$tagIds = this.getTagIds();
            Set<String> other$tagIds = other.getTagIds();
            return !(this$tagIds == null ? other$tagIds != null : !((Object)this$tagIds).equals(other$tagIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Item;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $percent = Double.doubleToLongBits(this.getPercent());
            result = result * 59 + (int)($percent >>> 32 ^ $percent);
            Set<String> $tagIds = this.getTagIds();
            result = result * 59 + ($tagIds == null ? 43 : ((Object)$tagIds).hashCode());
            return result;
        }

        public String toString() {
            return "TagMaxPercentConfig.Item(tagIds=" + this.getTagIds() + ", percent=" + this.getPercent() + ")";
        }
    }
}

