/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.auto.sdk;

import cn.insmart.mp.auto.sdk.dto.BrandLogoDTO;
import cn.insmart.mp.auto.sdk.dto.ModelPriceDTO;
import cn.insmart.mp.auto.sdk.dto.SerialGroupPicture;
import cn.insmart.mp.auto.sdk.dto.SerialGroupStandardPicture;
import cn.insmart.mp.auto.sdk.dto.SerialInfoDTO;
import feign.Param;
import feign.RequestLine;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public interface PriceApi {
    public static final String TARGET = "http://price.pcauto.com.cn";

    @RequestLine(value="GET /price/api/v1/pocket/serialgroup/serial_group_baipic?serialGroupId={serialId}")
    public List<SerialGroupPicture> getSerialGroupPictureList(@Param(value="serialId") long var1);

    default public SerialGroupPicture getSerialGroupPicture(long serialId) {
        List<SerialGroupPicture> list = this.getSerialGroupPictureList(serialId);
        return CollectionUtils.isEmpty(list) ? null : list.get(0);
    }

    @RequestLine(value="GET /price/api/v1/serialgroup/getSgStandardPic?sgId={serialId}")
    public SerialGroupStandardPicture getStandardAutoPictures(@Param(value="serialId") long var1);

    @RequestLine(value="GET /price/api/v1/brand/atom/brand_list")
    public BrandLogoDTO getBrandLogoList();

    default public BrandLogoDTO.BrandLogoObject getBrandLogo(long brandId) {
        BrandLogoDTO brandLogoList = this.getBrandLogoList();
        for (BrandLogoDTO.LetterBrand letterBrand : brandLogoList.getSections()) {
            for (BrandLogoDTO.BrandLogoObject letterBrandBrand : letterBrand.getBrands()) {
                if (!Objects.equals(letterBrandBrand.getId(), brandId)) continue;
                return letterBrandBrand;
            }
        }
        return null;
    }

    @RequestLine(value="GET /price/api/v1/serialgroup/serial_group_infos?sgid={serialId}")
    public SerialInfoDTO getSerialInfoById(@Param(value="serialId") long var1);

    @RequestLine(value="GET /price/api/v1/model/model_infos?isBatch=1&mids={modelIds}")
    public List<ModelPriceDTO> getModelPriceList(@Param(value="modelIds") String var1);
}

