/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.auto.sdk.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.Assert;

public class AreaDTO {
    @JsonProperty(value="result")
    Boolean result;
    @JsonProperty(value="areaData")
    List<Province> provinceList;
    @JsonIgnoreProperties
    Map<Long, Province> provinceMap;

    @JsonIgnoreProperties
    public Map<Long, Province> getProvinceMap() {
        Assert.notEmpty(this.provinceList, (String)"AreaDTO not init! provinceList is empty.");
        if (MapUtils.isEmpty(this.provinceMap) && CollectionUtils.isNotEmpty(this.provinceList)) {
            this.provinceMap = new HashMap<Long, Province>(this.provinceList.size());
            for (Province province : this.provinceList) {
                this.provinceMap.put(province.getProId(), province);
            }
        }
        return this.provinceMap;
    }

    @JsonIgnoreProperties
    public Province getProvince(Long provinceId) {
        return this.getProvinceMap().get(provinceId);
    }

    @JsonProperty(value="result")
    public void setResult(Boolean result) {
        this.result = result;
    }

    @JsonProperty(value="areaData")
    public void setProvinceList(List<Province> provinceList) {
        this.provinceList = provinceList;
    }

    @JsonIgnoreProperties
    public void setProvinceMap(Map<Long, Province> provinceMap) {
        this.provinceMap = provinceMap;
    }

    public String toString() {
        return "AreaDTO(result=" + this.getResult() + ", provinceList=" + this.getProvinceList() + ", provinceMap=" + this.getProvinceMap() + ")";
    }

    public Boolean getResult() {
        return this.result;
    }

    public List<Province> getProvinceList() {
        return this.provinceList;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class City {
        @JsonProperty(value="cityId")
        private Long cityId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="pinyin")
        private String pinyin;
        @JsonProperty(value="cityFirstLetter")
        private String cityFirstLetter;

        public Long getCityId() {
            return this.cityId;
        }

        public String getName() {
            return this.name;
        }

        public String getPinyin() {
            return this.pinyin;
        }

        public String getCityFirstLetter() {
            return this.cityFirstLetter;
        }

        @JsonProperty(value="cityId")
        public void setCityId(Long cityId) {
            this.cityId = cityId;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="pinyin")
        public void setPinyin(String pinyin) {
            this.pinyin = pinyin;
        }

        @JsonProperty(value="cityFirstLetter")
        public void setCityFirstLetter(String cityFirstLetter) {
            this.cityFirstLetter = cityFirstLetter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof City)) {
                return false;
            }
            City other = (City)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$cityId = this.getCityId();
            Long other$cityId = other.getCityId();
            if (this$cityId == null ? other$cityId != null : !((Object)this$cityId).equals(other$cityId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$pinyin = this.getPinyin();
            String other$pinyin = other.getPinyin();
            if (this$pinyin == null ? other$pinyin != null : !this$pinyin.equals(other$pinyin)) {
                return false;
            }
            String this$cityFirstLetter = this.getCityFirstLetter();
            String other$cityFirstLetter = other.getCityFirstLetter();
            return !(this$cityFirstLetter == null ? other$cityFirstLetter != null : !this$cityFirstLetter.equals(other$cityFirstLetter));
        }

        protected boolean canEqual(Object other) {
            return other instanceof City;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $cityId = this.getCityId();
            result = result * 59 + ($cityId == null ? 43 : ((Object)$cityId).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $pinyin = this.getPinyin();
            result = result * 59 + ($pinyin == null ? 43 : $pinyin.hashCode());
            String $cityFirstLetter = this.getCityFirstLetter();
            result = result * 59 + ($cityFirstLetter == null ? 43 : $cityFirstLetter.hashCode());
            return result;
        }

        public String toString() {
            return "AreaDTO.City(cityId=" + this.getCityId() + ", name=" + this.getName() + ", pinyin=" + this.getPinyin() + ", cityFirstLetter=" + this.getCityFirstLetter() + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Province {
        public static final Long DIRECTLY_CITY = 999L;
        @JsonProperty(value="citys")
        private List<City> cityList;
        @JsonProperty(value="proId")
        private Long proId;
        @JsonProperty(value="pro")
        private String name;
        @JsonProperty(value="proFirstLetter")
        private String proFirstLetter;

        public Long getProId() {
            return (Long)ObjectUtils.defaultIfNull((Object)this.proId, (Object)DIRECTLY_CITY);
        }

        @JsonProperty(value="citys")
        public void setCityList(List<City> cityList) {
            this.cityList = cityList;
        }

        @JsonProperty(value="proId")
        public void setProId(Long proId) {
            this.proId = proId;
        }

        @JsonProperty(value="pro")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="proFirstLetter")
        public void setProFirstLetter(String proFirstLetter) {
            this.proFirstLetter = proFirstLetter;
        }

        public String toString() {
            return "AreaDTO.Province(cityList=" + this.getCityList() + ", proId=" + this.getProId() + ", name=" + this.getName() + ", proFirstLetter=" + this.getProFirstLetter() + ")";
        }

        public List<City> getCityList() {
            return this.cityList;
        }

        public String getName() {
            return this.name;
        }

        public String getProFirstLetter() {
            return this.proFirstLetter;
        }
    }
}

