/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.auto.sdk.support;

import cn.insmart.fx.common.lang.util.Message;
import cn.insmart.fx.oss.OssTemplate;
import cn.insmart.fx.oss.emuns.BucketTypeEnum;
import cn.insmart.fx.oss.path.KeyPath;
import cn.insmart.mp.auto.sdk.AutoApi;
import cn.insmart.mp.auto.sdk.config.AutoApiConfig;
import cn.insmart.mp.auto.sdk.dto.AreaDTO;
import cn.insmart.mp.auto.sdk.dto.BrandDTO;
import cn.insmart.mp.auto.sdk.dto.BrandLogoDTO;
import cn.insmart.mp.auto.sdk.dto.DasRelateSerialDTO;
import cn.insmart.mp.auto.sdk.dto.SerialGroupPicture;
import cn.insmart.mp.auto.sdk.dto.SerialGroupStandardPicture;
import cn.insmart.mp.auto.sdk.exception.AutoSdkException;
import cn.insmart.mp.auto.sdk.exception.DownloadException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import javax.imageio.ImageIO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.retry.support.RetryTemplateBuilder;
import org.springframework.util.Assert;

public class DefaultAutoApi
implements AutoApi {
    private static final Logger log = LoggerFactory.getLogger(DefaultAutoApi.class);
    private final AutoApiConfig config;
    private final HttpClient client;
    private final ObjectMapper mapper;
    private final OssTemplate ossTemplate;
    private final RetryTemplate retryTemplate = new RetryTemplateBuilder().retryOn(ConnectException.class).build();

    public DefaultAutoApi(AutoApiConfig config, OssTemplate ossTemplate) {
        log.info("DefaultAutoApi: config: {}", (Object)config);
        this.config = Objects.requireNonNull(config, "\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        this.client = this.initClient(config);
        this.mapper = new ObjectMapper();
        this.ossTemplate = ossTemplate;
    }

    private HttpClient initClient(AutoApiConfig config) {
        AutoApiConfig.ProxyProperties proxy = config.getProxy();
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (Objects.nonNull(proxy) && StringUtils.isNotBlank((CharSequence)proxy.getHost())) {
            builder.proxy(ProxySelector.of(new InetSocketAddress(proxy.getHost(), (int)proxy.getPort())));
        }
        builder.connectTimeout(Duration.ofSeconds(60L));
        return builder.build();
    }

    @Override
    public List<BrandDTO> getBrandList() {
        return this.requestObject(this.config.getBrandListApi(), new TypeReference<List<BrandDTO>>(){});
    }

    @Override
    public SerialGroupPicture getSerialGroupPicture(long serialId) {
        List<SerialGroupPicture> list = this.requestObject(this.config.getSerialImageApi() + serialId, new TypeReference<List<SerialGroupPicture>>(){});
        if (CollectionUtils.isEmpty(list)) {
            log.info("\u627e\u4e0d\u5230\u8f66\u7cfbID={}\u7684\u56fe\u7247\u4fe1\u606f", (Object)serialId);
            return null;
        }
        return list.get(0);
    }

    @Override
    public SerialGroupStandardPicture getStandardAutoPictures(long serialId) {
        return this.requestObject(this.config.getSerialPictureApi() + serialId, new TypeReference<SerialGroupStandardPicture>(){});
    }

    @Override
    public Path download(String url) throws AutoSdkException {
        File dir = DEFAULT_DOWNLOAD_DIRECTORY;
        try {
            FileUtils.forceMkdir((File)dir);
        }
        catch (IOException e) {
            throw new AutoSdkException("\u4e0b\u8f7d\u56fe\u4e0d\u80fd\u521b\u5efa\u76ee\u5f55", (Throwable)e, dir);
        }
        String name = String.format("download_%s_%s_%s", Thread.currentThread().getId(), System.currentTimeMillis(), FilenameUtils.getName((String)url));
        HttpResponse.BodyHandler<Path> pathBodyHandler = HttpResponse.BodyHandlers.ofFile(Path.of(dir.getAbsolutePath(), name));
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
        String header = "Content-Length";
        try {
            for (int i = 0; i < 3; ++i) {
                HttpResponse<Path> response = this.client.send(request, pathBodyHandler);
                OptionalLong optionalLong = response.headers().firstValueAsLong(header);
                long responseSize = optionalLong.orElseThrow(() -> new DownloadException("\u4e0b\u8f7d\u4e3aURL %s \u8fd4\u56de\u5934\u6ca1\u6709\u5c5e\u6027 %s ", url, header));
                Path file = response.body();
                long size = Files.size(file);
                if (responseSize > 0L && size == responseSize) {
                    return file;
                }
                log.warn("\u6587\u4ef6\u4e0b\u8f7d\u51fa\u9519 {} \u5927\u5c0f[ {} ],\u4e0b\u8f7d\u5b58\u50a8\u5927\u5c0f[ {}],\u8def\u5f84 {}, \u53ef\u80fd\u5b58\u5728\u7f51\u7edc\u6296\u52a8\uff0c statusCode:{}, \u5c1d\u8bd5:{}\u6b21", new Object[]{header, responseSize, size, file, response.statusCode(), i + 1});
                Thread.sleep((i + 1) * 1000);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new DownloadException("\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519 URL:%s", (Throwable)e, url);
        }
        throw new DownloadException("\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519 URL:%s", url);
    }

    @Override
    public DasRelateSerialDTO getDasRelateSerials(long serialId) {
        List<DasRelateSerialDTO> list = this.requestObject(this.config.getDasRelateSerialApi() + serialId, new TypeReference<List<DasRelateSerialDTO>>(){});
        return CollectionUtils.isEmpty(list) ? null : list.get(0);
    }

    @Override
    public BufferedImage getBrandLogo(long brandId) throws IOException {
        BufferedImage bufferedImage;
        InputStream inputStream = null;
        String path = "auto-api-download/brand-logo/" + brandId + ".jpg";
        try {
            inputStream = this.ossTemplate.getObjectAsInputStream(BucketTypeEnum.PUBLIC, KeyPath.of((BucketTypeEnum)BucketTypeEnum.PUBLIC, (String)path, (String[])new String[0]));
        }
        catch (Exception e) {
            log.error("ossTemplate openInputStream error 1. file {}, {}", (Object)path, (Object)e.getMessage());
        }
        if (inputStream != null) {
            return ImageIO.read(inputStream);
        }
        String imageUrl = this.getBrandLogoUrl(brandId);
        String extension = FilenameUtils.getExtension((String)imageUrl);
        if (!StringUtils.equals((CharSequence)"jpg", (CharSequence)extension)) {
            try {
                KeyPath ossPath = KeyPath.of((BucketTypeEnum)BucketTypeEnum.PUBLIC, (String)"auto-api-download", (String[])new String[]{"brand-logo", brandId + "." + extension});
                inputStream = this.ossTemplate.getObjectAsInputStream(BucketTypeEnum.PUBLIC, ossPath);
            }
            catch (Exception e) {
                log.error("ossTemplate openInputStream error 2. file {}", (Object)("auto-api-download/brand-logo/" + brandId + "." + extension));
            }
            if (inputStream != null) {
                return ImageIO.read(inputStream);
            }
        }
        File file = null;
        try {
            Path tempPath = this.download(imageUrl);
            file = tempPath.toFile();
            log.info("retry extension: {}, url: {}, file: {}", new Object[]{extension, imageUrl, tempPath.toFile().getAbsolutePath()});
            Assert.isTrue((boolean)file.exists(), (String)Message.of((String)"brand: {}, tempFile {} is not exists", (Object[])new Object[]{brandId, file.getAbsolutePath()}));
            try {
                this.ossTemplate.putObject(BucketTypeEnum.PUBLIC, KeyPath.of((BucketTypeEnum)BucketTypeEnum.PUBLIC, (String)"auto-api-download", (String[])new String[]{"brand-logo", brandId + "." + extension}), tempPath.toFile());
            }
            catch (Exception e) {
                log.info("put to oss error! {}, {}", (Object)(brandId + "." + extension), (Object)e.getMessage());
            }
            bufferedImage = ImageIO.read(file);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(file);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)file);
        return bufferedImage;
    }

    @Override
    public AreaDTO getAutoArea() {
        return this.requestObject(this.config.getAutoAreaApi(), new TypeReference<AreaDTO>(){});
    }

    public String getBrandLogoUrl(long brandId) {
        BrandLogoDTO logoDTO = this.requestObject(this.config.getBrandLogoApi(), new TypeReference<BrandLogoDTO>(){});
        Assert.isTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{logoDTO}), (String)Message.of((String)"get brandLogoDto is null. bid: {}", (Object[])new Object[]{brandId}));
        for (BrandLogoDTO.LetterBrand section : logoDTO.getSections()) {
            for (BrandLogoDTO.BrandLogoObject brand : section.getBrands()) {
                if (brand.getId() != brandId) continue;
                return brand.getLogo();
            }
        }
        return null;
    }

    private <T> T requestObject(String url, TypeReference<T> typeReference) {
        try {
            return (T)this.mapper.readValue(this.fixJSON(this.request(url, HttpResponse.BodyHandlers.ofString())), typeReference);
        }
        catch (IOException e) {
            throw new AutoSdkException("\u683c\u5f0f\u5316JSON\u62a5\u9519, url=%s,", (Throwable)e, url);
        }
    }

    private <T> T request(String url, HttpResponse.BodyHandler<T> handler) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
        return (T)this.retryTemplate.execute(retryContext -> {
            try {
                HttpResponse response = this.client.send(request, handler);
                if (response.statusCode() != 200 && response.statusCode() != 302) {
                    throw new RuntimeException(ToStringBuilder.reflectionToString(response));
                }
                return response.body();
            }
            catch (IOException | InterruptedException ex) {
                throw new AutoSdkException(String.format("\u8bf7\u6c42URL\uff1a%s, \u51fa\u9519", url), (Throwable)ex, new Object[0]);
            }
        });
    }

    private String fixJSON(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return null;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)(data = data.trim()), (CharSequence)"callback(")) {
            data = data.replace("callback", data).substring(data.indexOf("(") + 1, data.lastIndexOf(")"));
        }
        if (StringUtils.startsWith((CharSequence)data, (CharSequence)"var") && (data = data.substring(data.indexOf("=") + 1).trim()).endsWith(";")) {
            data = data.substring(0, data.length() - 1);
        }
        return data;
    }

    public static void main(String[] args) throws IOException {
    }

    public DefaultAutoApi(AutoApiConfig config, HttpClient client, ObjectMapper mapper, OssTemplate ossTemplate) {
        this.config = config;
        this.client = client;
        this.mapper = mapper;
        this.ossTemplate = ossTemplate;
    }
}

