/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.auto.sdk.support;

import cn.insmart.mp.auto.sdk.config.AutoApiConfig;
import feign.Client;
import feign.Retryer;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeignUtils.class);

    public static Retryer createRetryer(AutoApiConfig config) {
        AutoApiConfig.RetryProperties retry = config.getRetry();
        if (Objects.nonNull(retry)) {
            LOGGER.info("AutoApi \u7528\u6237\u81ea\u5b9a\u4e49Retry : {} ", (Object)retry);
            return new Retryer.Default(retry.getPeriod().longValue(), retry.getMaxPeriod().longValue(), retry.getMaxAttempts().intValue());
        }
        return new Retryer.Default();
    }

    public static Client createClient(AutoApiConfig config) {
        AutoApiConfig.ProxyProperties proxy = config.getProxy();
        if (Objects.nonNull(config.getProxy())) {
            InetSocketAddress address = new InetSocketAddress(proxy.getHost(), (int)proxy.getPort());
            LOGGER.info("AutoApi \u4f7f\u7528\u4ee3\u7406\uff1a{}:{}", (Object)proxy.getHost(), (Object)proxy.getPort());
            return new Client.Proxied(null, null, new Proxy(Proxy.Type.HTTP, address));
        }
        return new Client.Default(null, null);
    }
}

