/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.baidufeed.sdk.support;

import cn.insmart.mp.baidufeed.sdk.dto.Response;
import cn.insmart.mp.baidufeed.sdk.dto.ResponseDTO;
import cn.insmart.mp.baidufeed.sdk.exception.AccessTokenErrorException;
import cn.insmart.mp.baidufeed.sdk.exception.AccessTokenExpiredException;
import cn.insmart.mp.baidufeed.sdk.exception.DataNotOnlyException;
import cn.insmart.mp.baidufeed.sdk.exception.ParameterException;
import cn.insmart.mp.baidufeed.sdk.exception.SdkException;
import cn.insmart.mp.baidufeed.sdk.exception.SdkTimeoutException;
import cn.insmart.mp.baidufeed.sdk.exception.TokenInvalidException;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CodeChecker {
    public static <T> T check(T returnValue, Object request) {
        if (!(returnValue instanceof Response)) {
            return returnValue;
        }
        ResponseDTO response = (ResponseDTO)returnValue;
        Long code = response.getCode();
        if (Objects.isNull(code) || code == 0L) {
            return returnValue;
        }
        if (Objects.equals(402000L, code)) {
            throw new AccessTokenExpiredException("AccessToken \u8fc7\u671f, %s", response);
        }
        if (Objects.equals(401000L, code) && StringUtils.contains((CharSequence)response.getMessage(), (CharSequence)"\u4e00\u4e2a\u5e7f\u544a\u7ec4\u4e0b\u53ea\u80fd\u6709\u4e00\u4e2a\u7a0b\u5e8f\u5316\u521b\u610f")) {
            throw new DataNotOnlyException("\u6570\u636e\u4e0d\u552f\u4e00, %s", response);
        }
        if (Objects.equals(401000L, code) && StringUtils.contains((CharSequence)response.getMessage(), (CharSequence)"\u8be5\u5e7f\u544a\u7ec4\u4e0b\u5e7f\u544a\u521b\u610f\u540d\u91cd\u590d")) {
            throw new DataNotOnlyException("\u6570\u636e\u4e0d\u552f\u4e00, %s", response);
        }
        if (Objects.equals(402004L, code)) {
            throw new AccessTokenErrorException("AccessToken \u9519\u8bef, %s", response);
        }
        if (Objects.equals(401000L, code)) {
            throw new ParameterException(JSON.toJSONString(Map.of("response", response, "request", request)), new Object[0]);
        }
        if (Objects.equals(50000L, code)) {
            throw new SdkTimeoutException(request, response);
        }
        if (Objects.equals(code, 40105L)) {
            throw new TokenInvalidException(request, response);
        }
        throw new SdkException(JSON.toJSONString(Map.of("response", response, "request", request)), new Object[0]);
    }
}

