/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.baidufeed.sdk.support;

import cn.insmart.mp.baidufeed.sdk.config.SdkProperties;
import cn.insmart.mp.baidufeed.sdk.exception.AccessTokenExpiredException;
import cn.insmart.mp.baidufeed.sdk.support.CodeChecker;
import cn.insmart.mp.baidufeed.sdk.support.QpsLimiter;
import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Target;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InvocationHandlerFactory
implements feign.InvocationHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(InvocationHandlerFactory.class);
    private final SdkProperties sdkProperties;

    public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        return new InvocationHandler(target, dispatch);
    }

    public InvocationHandlerFactory(SdkProperties sdkProperties) {
        this.sdkProperties = sdkProperties;
    }

    public SdkProperties getSdkProperties() {
        return this.sdkProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvocationHandlerFactory)) {
            return false;
        }
        InvocationHandlerFactory other = (InvocationHandlerFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SdkProperties this$sdkProperties = this.getSdkProperties();
        SdkProperties other$sdkProperties = other.getSdkProperties();
        return !(this$sdkProperties == null ? other$sdkProperties != null : !((Object)this$sdkProperties).equals(other$sdkProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvocationHandlerFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SdkProperties $sdkProperties = this.getSdkProperties();
        result = result * 59 + ($sdkProperties == null ? 43 : ((Object)$sdkProperties).hashCode());
        return result;
    }

    public String toString() {
        return "InvocationHandlerFactory(sdkProperties=" + this.getSdkProperties() + ")";
    }

    class InvocationHandler
    implements java.lang.reflect.InvocationHandler {
        private final Target target;
        private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke(proxy, args);
            }
            QpsLimiter.limit(method);
            Objects.requireNonNull(args, "\u63a5\u53e3\u65b9\u6cd5\u5fc5\u987b\u6709\u53c2\u6570\u5b9a\u4e49");
            int i = 0;
            while (true) {
                try {
                    return CodeChecker.check(this.dispatch.get(method).invoke(args), args);
                }
                catch (AccessTokenExpiredException e) {
                    return CodeChecker.check(this.dispatch.get(method).invoke(args), args);
                }
                catch (FeignException.GatewayTimeout e) {
                    if (i > InvocationHandlerFactory.this.sdkProperties.getTimeoutRetry()) {
                        throw e;
                    }
                    log.info("\u7f51\u5173\u8d85\u65f6 \u5c1d\u8bd5\u6b21\u6570: {} {}", (Object)i, (Object)e.getMessage());
                    ++i;
                    continue;
                }
                break;
            }
        }

        public InvocationHandler(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
            this.target = target;
            this.dispatch = dispatch;
        }

        public Target getTarget() {
            return this.target;
        }

        public Map<Method, InvocationHandlerFactory.MethodHandler> getDispatch() {
            return this.dispatch;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvocationHandler)) {
                return false;
            }
            InvocationHandler other = (InvocationHandler)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Target this$target = this.getTarget();
            Target other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            Map<Method, InvocationHandlerFactory.MethodHandler> this$dispatch = this.getDispatch();
            Map<Method, InvocationHandlerFactory.MethodHandler> other$dispatch = other.getDispatch();
            return !(this$dispatch == null ? other$dispatch != null : !((Object)this$dispatch).equals(other$dispatch));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InvocationHandler;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Target $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            Map<Method, InvocationHandlerFactory.MethodHandler> $dispatch = this.getDispatch();
            result = result * 59 + ($dispatch == null ? 43 : ((Object)$dispatch).hashCode());
            return result;
        }

        public String toString() {
            return "InvocationHandlerFactory.InvocationHandler(target=" + this.getTarget() + ", dispatch=" + this.getDispatch() + ")";
        }
    }
}

