/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.baidufeed.sdk.dto;

import cn.insmart.mp.baidufeed.sdk.dto.Failure;
import cn.insmart.mp.baidufeed.sdk.dto.HttpResponseHeader;
import cn.insmart.mp.baidufeed.sdk.dto.ListBody;
import cn.insmart.mp.baidufeed.sdk.dto.ResHeader;
import java.beans.Transient;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class Response<K> {
    private ResHeader header;
    private K body;
    private HttpResponseHeader httpResponseHeader;

    @Transient
    public Optional<K> body() {
        return Optional.ofNullable(this.body);
    }

    @Transient
    public List<Failure> failures() {
        return Optional.ofNullable(this.header.getFailures()).orElseGet(Collections::emptyList);
    }

    @Transient
    public Map<Long, Failure> failureMap() {
        return this.failures().stream().collect(Collectors.toMap(failure -> Objects.requireNonNull(failure.getId(), () -> {
            throw new RuntimeException("ID \u4e3a\u7a7a %s" + this);
        }), Function.identity()));
    }

    public <T> List<T> list() {
        if (this.body instanceof ListBody) {
            List list = ((ListBody)ListBody.class.cast(this.body)).getData();
            return Optional.ofNullable(list).orElseGet(Collections::emptyList);
        }
        throw new UnsupportedOperationException("body is not List");
    }

    public Response<K> checkFailure() {
        List<Failure> failures = this.getHeader().getFailures();
        if (CollectionUtils.isNotEmpty(failures)) {
            throw new RuntimeException("\u6709\u9519\u8bef" + failures);
        }
        return this;
    }

    public boolean hasFailure() {
        return CollectionUtils.isNotEmpty(this.header.getFailures());
    }

    public boolean notFailure() {
        return !this.hasFailure();
    }

    public ResHeader getHeader() {
        return this.header;
    }

    public K getBody() {
        return this.body;
    }

    public HttpResponseHeader getHttpResponseHeader() {
        return this.httpResponseHeader;
    }

    public void setHeader(ResHeader header) {
        this.header = header;
    }

    public void setBody(K body) {
        this.body = body;
    }

    public void setHttpResponseHeader(HttpResponseHeader httpResponseHeader) {
        this.httpResponseHeader = httpResponseHeader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResHeader this$header = this.getHeader();
        ResHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        K this$body = this.getBody();
        K other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        HttpResponseHeader this$httpResponseHeader = this.getHttpResponseHeader();
        HttpResponseHeader other$httpResponseHeader = other.getHttpResponseHeader();
        return !(this$httpResponseHeader == null ? other$httpResponseHeader != null : !((Object)this$httpResponseHeader).equals(other$httpResponseHeader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        K $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        HttpResponseHeader $httpResponseHeader = this.getHttpResponseHeader();
        result = result * 59 + ($httpResponseHeader == null ? 43 : ((Object)$httpResponseHeader).hashCode());
        return result;
    }

    public String toString() {
        return "Response(header=" + this.getHeader() + ", body=" + this.getBody() + ", httpResponseHeader=" + this.getHttpResponseHeader() + ")";
    }
}

