/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.baidufeed.sdk.support;

import cn.insmart.fx.common.lang.util.StringUtils;
import cn.insmart.mp.baidufeed.sdk.Api;
import cn.insmart.mp.baidufeed.sdk.ApiFactory;
import cn.insmart.mp.baidufeed.sdk.coder.Coder;
import cn.insmart.mp.baidufeed.sdk.coder.FieldQueryMapEncoder;
import cn.insmart.mp.baidufeed.sdk.coder.JacksonDecoder;
import cn.insmart.mp.baidufeed.sdk.coder.JacksonEncoder;
import cn.insmart.mp.baidufeed.sdk.config.SdkProperties;
import cn.insmart.mp.baidufeed.sdk.dto.AuthHeader;
import cn.insmart.mp.baidufeed.sdk.dto.AuthRequest;
import cn.insmart.mp.baidufeed.sdk.dto.Header;
import cn.insmart.mp.baidufeed.sdk.dto.Request;
import cn.insmart.mp.baidufeed.sdk.exception.AccessTooFrequentException;
import cn.insmart.mp.baidufeed.sdk.exception.AuthAccessTooFrequentException;
import cn.insmart.mp.baidufeed.sdk.exception.AuthFailureException;
import cn.insmart.mp.baidufeed.sdk.exception.AuthRetryAgainException;
import cn.insmart.mp.baidufeed.sdk.exception.FailureException;
import cn.insmart.mp.baidufeed.sdk.exception.RetryAgainException;
import cn.insmart.mp.baidufeed.sdk.service.FeedTokenService;
import cn.insmart.mp.baidufeed.sdk.support.InvocationHandlerFactory;
import cn.insmart.mp.baidufeed.sdk.support.LoggerLevelResolver;
import cn.insmart.mp.baidufeed.sdk.support.MccProperties;
import cn.insmart.mp.baidufeed.sdk.support.ObjectMappers;
import cn.insmart.mp.baidufeed.sdk.support.QpsLimiter;
import cn.insmart.mp.baidufeed.sdk.support.SdkChecker;
import cn.insmart.mp.baidufeed.sdk.support.TokenProvider;
import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.QueryMapEncoder;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.httpclient.ApacheHttpClient;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApiFactory
implements ApiFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultApiFactory.class);
    private final SdkProperties sdkProperties;
    private final MccProperties mccProperties;
    private final TokenProvider tokenProvider;

    public DefaultApiFactory(MccProperties mccProperties, SdkProperties sdkProperties, TokenProvider tokenProvider) {
        this.sdkProperties = Objects.requireNonNull(sdkProperties, "SdkProperties is null");
        this.mccProperties = mccProperties;
        this.tokenProvider = tokenProvider;
    }

    @Override
    public <T extends Api> T create(Class<T> service, String targetAccount) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.sdkProperties.getProxy() != null && StringUtils.isNotBlank((CharSequence)this.sdkProperties.getProxy().getHost())) {
            HttpHost httpHost = new HttpHost(this.sdkProperties.getProxy().getHost(), this.sdkProperties.getProxy().getPort());
            builder.setProxy(httpHost);
        }
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(this.getSSLContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
        return (T)((Api)Feign.builder().invocationHandlerFactory(this.invocationHandlerFactory(targetAccount)).decoder((Decoder)new Coder(this.sdkProperties)).encoder((Encoder)new Coder(this.sdkProperties)).client((Client)new ApacheHttpClient((HttpClient)builder.build())).target(service, this.sdkProperties.getApi()));
    }

    @Override
    public <T extends Api> T createWithoutId(Class<T> service) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.sdkProperties.getProxy() != null && StringUtils.isNotBlank((CharSequence)this.sdkProperties.getProxy().getHost())) {
            HttpHost httpHost = new HttpHost(this.sdkProperties.getProxy().getHost(), this.sdkProperties.getProxy().getPort());
            builder.setProxy(httpHost);
        }
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(this.getSSLContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
        String api = this.sdkProperties.getApi();
        if (FeedTokenService.class.equals(service)) {
            api = "https://u.baidu.com/oauth";
        }
        return (T)((Api)Feign.builder().invocationHandlerFactory((feign.InvocationHandlerFactory)new InvocationHandlerFactory(this.sdkProperties)).queryMapEncoder((QueryMapEncoder)new FieldQueryMapEncoder()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(ObjectMappers.getMapper()))).decoder((Decoder)new JacksonDecoder()).client((Client)new ApacheHttpClient((HttpClient)builder.build())).logLevel(LoggerLevelResolver.resolve(this.sdkProperties.getLoggerLevel())).logger(new feign.Logger(){

            protected void log(String configKey, String format, Object ... args) {
                log.info("feign: {}, {}", (Object)format, (Object)args);
            }
        }).target(service, api));
    }

    @Override
    public <T extends Api> T createByAuth(Class<T> service, String targetAccount) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.sdkProperties.getProxy() != null && StringUtils.isNotBlank((CharSequence)this.sdkProperties.getProxy().getHost())) {
            HttpHost httpHost = new HttpHost(this.sdkProperties.getProxy().getHost(), this.sdkProperties.getProxy().getPort());
            builder.setProxy(httpHost);
        }
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(this.getSSLContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
        return (T)((Api)Feign.builder().invocationHandlerFactory(this.authInvocationHandlerFactory(targetAccount)).decoder((Decoder)new Coder(this.sdkProperties)).encoder((Encoder)new Coder(this.sdkProperties)).client((Client)new ApacheHttpClient((HttpClient)builder.build())).target(service, this.sdkProperties.getApi()));
    }

    private feign.InvocationHandlerFactory invocationHandlerFactory(String targetAccount) {
        return (target, dispatch) -> (proxy, method, args) -> {
            if (method.isDefault()) {
                Class<?> declaringClass = method.getDeclaringClass();
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(declaringClass, MethodHandles.lookup());
                MethodHandle special = lookup.findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass);
                return special.bindTo(proxy).invokeWithArguments(args);
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke((Object)this, args);
            }
            Objects.requireNonNull(args, "\u63a5\u53e3\u65b9\u6cd5\u5fc5\u987b\u6709\u53c2\u6570\u5b9a\u4e49");
            Header authHeader = new Header();
            authHeader.setUsername(this.mccProperties.getUsername());
            authHeader.setPassword(this.mccProperties.getPassword());
            authHeader.setToken(this.mccProperties.getToken());
            authHeader.setTarget(targetAccount);
            Request<Object[]> request = new Request<Object[]>(authHeader, (Object[])(args.length == 1 ? args[0] : args));
            int i = 1;
            while (true) {
                try {
                    QpsLimiter.limit(method);
                    Object returnValue = ((InvocationHandlerFactory.MethodHandler)dispatch.get(method)).invoke(new Object[]{request});
                    SdkChecker.check(method, returnValue, request);
                    return returnValue;
                }
                catch (AccessTooFrequentException | RetryAgainException | FeignException.GatewayTimeout | FeignException.InternalServerError e) {
                    log.warn("SDK \u91cd\u8bd5 {}({}): {}", new Object[]{i, this.sdkProperties.getTimeoutRetry(), e.getMessage()});
                    if (i > this.sdkProperties.getTimeoutRetry()) {
                        if (e instanceof FailureException) {
                            FailureException fe = (FailureException)e;
                            throw new FailureException(method, fe.getFailure(), fe.getRequest(), fe.getResponse(), String.format("sdk request error:", fe), new Object[0]);
                        }
                        throw e;
                    }
                    TimeUnit.SECONDS.sleep(Math.min(i, 10));
                    ++i;
                    continue;
                }
                break;
            }
        };
    }

    private feign.InvocationHandlerFactory authInvocationHandlerFactory(String targetAccount) {
        return (target, dispatch) -> (proxy, method, args) -> {
            if (method.isDefault()) {
                Class<?> declaringClass = method.getDeclaringClass();
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(declaringClass, MethodHandles.lookup());
                MethodHandle special = lookup.findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass);
                return special.bindTo(proxy).invokeWithArguments(args);
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke((Object)this, args);
            }
            Objects.requireNonNull(args, "\u63a5\u53e3\u65b9\u6cd5\u5fc5\u987b\u6709\u53c2\u6570\u5b9a\u4e49");
            AuthHeader authHeader = new AuthHeader();
            authHeader.setUserName(targetAccount);
            authHeader.setAccessToken(this.tokenProvider.getToken(targetAccount));
            AuthRequest<Object[]> request = new AuthRequest<Object[]>(authHeader, (Object[])(args.length == 1 ? args[0] : args));
            int i = 1;
            while (true) {
                try {
                    QpsLimiter.limit(method);
                    Object returnValue = ((InvocationHandlerFactory.MethodHandler)dispatch.get(method)).invoke(new Object[]{request});
                    SdkChecker.checkAuth(method, returnValue, request);
                    return returnValue;
                }
                catch (AuthAccessTooFrequentException | AuthRetryAgainException | FeignException.GatewayTimeout | FeignException.InternalServerError e) {
                    log.warn("SDK \u91cd\u8bd5 {}({}): {}", new Object[]{i, this.sdkProperties.getTimeoutRetry(), e.getMessage()});
                    if (i > this.sdkProperties.getTimeoutRetry()) {
                        if (e instanceof AuthFailureException) {
                            AuthFailureException fe = (AuthFailureException)e;
                            throw new AuthFailureException(method, fe.getFailure(), fe.getRequest(), fe.getResponse(), String.format("sdk request error:", fe), new Object[0]);
                        }
                        throw e;
                    }
                    TimeUnit.SECONDS.sleep(Math.min(i, 10));
                    ++i;
                    continue;
                }
                break;
            }
        };
    }

    private SSLContext getSSLContext() {
        try {
            return SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Client client(SdkProperties.ProxyProperties proxyConfiguration) {
        if (Objects.nonNull(proxyConfiguration)) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfiguration.getHost(), proxyConfiguration.getPort()));
            return new Client.Proxied(null, null, proxy);
        }
        return new Client.Default(null, null);
    }

    protected SdkProperties getSdkProperties() {
        return this.sdkProperties;
    }

    protected MccProperties getMccProperties() {
        return this.mccProperties;
    }

    protected TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }
}

