/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.baidufeed.sdk.exception;

import cn.insmart.mp.baidufeed.sdk.dto.Failure;
import cn.insmart.mp.baidufeed.sdk.dto.Request;
import cn.insmart.mp.baidufeed.sdk.dto.Response;
import cn.insmart.mp.baidufeed.sdk.exception.SdkException;
import java.lang.reflect.Method;

public class FailureException
extends SdkException {
    private final Method method;
    private final Request request;
    private final Response response;
    private final Failure failure;

    public FailureException(Method method, Failure failure, Request request, Response response) {
        this(method, failure, request, response, String.format("%s.%s, error: %s", method.getDeclaringClass().getSimpleName(), method.getName(), failure.getMessage()), new Object[0]);
    }

    public FailureException(Method method, Failure failure, Request request, Response response, String message, Object ... args) {
        super(message, args);
        this.method = method;
        this.request = request;
        this.response = response;
        this.failure = failure;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("method: ").append(this.method);
        sb.append("failure: ").append(this.failure);
        sb.append("request: ").append(this.request);
        sb.append("response: ").append(this.response);
        return sb.toString();
    }

    public Method getMethod() {
        return this.method;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public Failure getFailure() {
        return this.failure;
    }
}

