/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.baidufeed.sdk.support;

import cn.insmart.fx.common.lang.util.Message;
import cn.insmart.fx.common.lang.util.ResourceUtils;
import cn.insmart.mp.baidufeed.sdk.dto.AuthRequest;
import cn.insmart.mp.baidufeed.sdk.dto.Failure;
import cn.insmart.mp.baidufeed.sdk.dto.Request;
import cn.insmart.mp.baidufeed.sdk.dto.Response;
import cn.insmart.mp.baidufeed.sdk.exception.AccessTooFrequentException;
import cn.insmart.mp.baidufeed.sdk.exception.AuthAccessTooFrequentException;
import cn.insmart.mp.baidufeed.sdk.exception.AuthFailureException;
import cn.insmart.mp.baidufeed.sdk.exception.AuthRetryAgainException;
import cn.insmart.mp.baidufeed.sdk.exception.FailureException;
import cn.insmart.mp.baidufeed.sdk.exception.RetryAgainException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SdkChecker.class);
    public static final List<Long> SYSTEM_ERROR_CODE;
    public static final String SYSTEM_ERROR_FILE_CSV = "system_error.csv";

    public static void check(Method method, Object returnValue, Request<Object> request) throws RetryAgainException {
        if (!(returnValue instanceof Response)) {
            return;
        }
        Response response = (Response)returnValue;
        List<Failure> failures = response.failures();
        if (CollectionUtils.isEmpty(failures)) {
            return;
        }
        for (Failure failure : failures) {
            Long code = failure.getCode();
            if (Arrays.asList(800L, 8001L, 90199911L, 9013L, 9013001L, 9013002L, 9013003L, 9013004L).contains(code)) {
                throw new RetryAgainException(method, failure, request, response);
            }
            if (Set.of(Long.valueOf(99942L)).contains(code)) {
                throw new AccessTooFrequentException(method, failure, request, response);
            }
            if (!SYSTEM_ERROR_CODE.contains(code)) continue;
            throw new FailureException(method, failure, request, response);
        }
    }

    public static void checkAuth(Method method, Object returnValue, AuthRequest<Object> request) throws RetryAgainException {
        if (!(returnValue instanceof Response)) {
            return;
        }
        Response response = (Response)returnValue;
        List<Failure> failures = response.failures();
        if (CollectionUtils.isEmpty(failures)) {
            return;
        }
        for (Failure failure : failures) {
            Long code = failure.getCode();
            if (Arrays.asList(800L, 8001L, 90199911L, 9013L, 9013001L, 9013002L, 9013003L, 9013004L).contains(code)) {
                throw new AuthRetryAgainException(method, failure, request, response);
            }
            if (Set.of(Long.valueOf(99942L)).contains(code)) {
                throw new AuthAccessTooFrequentException(method, failure, request, response);
            }
            if (!SYSTEM_ERROR_CODE.contains(code)) continue;
            throw new AuthFailureException(method, failure, request, response);
        }
    }

    static {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            InputStream inputStream = Objects.requireNonNull(ResourceUtils.getResourceAsStream((String)SYSTEM_ERROR_FILE_CSV), () -> Message.of((String)"\u52a0\u8f7d\u6587\u4ef6 {} \u5931\u8d25", (Object[])new Object[]{SYSTEM_ERROR_FILE_CSV}));
            try (CSVParser parse = CSVParser.parse((InputStream)inputStream, (Charset)Charset.forName("GBK"), (CSVFormat)CSVFormat.RFC4180.withFirstRecordAsHeader());){
                for (CSVRecord record : parse) {
                    list.add(Long.valueOf(record.get("code")));
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("\u52a0\u8f7d\u914d\u51fa\u9519", e);
        }
        SYSTEM_ERROR_CODE = Collections.unmodifiableList(list);
    }
}

