/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.baidufeed.sdk.config;

import cn.insmart.mp.baidufeed.sdk.ApiFactoryManager;
import cn.insmart.mp.baidufeed.sdk.config.SdkProperties;
import cn.insmart.mp.baidufeed.sdk.support.DataSourceTokenProvider;
import cn.insmart.mp.baidufeed.sdk.support.DefaultApiFactoryManager;
import cn.insmart.mp.baidufeed.sdk.support.TokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SdkProperties.class})
public class SdkAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SdkAutoConfiguration.class);

    @Bean
    TokenProvider tokenProvider(SdkProperties properties) {
        log.info("toutiao SdkProperties {}", (Object)properties);
        SdkProperties.DataSourceProperties dataSourceProperties = properties.getDataSource();
        return new DataSourceTokenProvider(dataSourceProperties);
    }

    @Bean
    ApiFactoryManager apiServiceFactoryManager(SdkProperties properties, TokenProvider tokenProvider) {
        return new DefaultApiFactoryManager(properties, tokenProvider);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SdkAutoConfiguration)) {
            return false;
        }
        SdkAutoConfiguration other = (SdkAutoConfiguration)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof SdkAutoConfiguration;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "SdkAutoConfiguration()";
    }
}

