/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.kuaishou.sdk.core.configuration;

import cn.insmart.mp.kuaishou.sdk.core.ApiFactoryManager;
import cn.insmart.mp.kuaishou.sdk.core.TokenProvider;
import cn.insmart.mp.kuaishou.sdk.core.TokenRefresher;
import cn.insmart.mp.kuaishou.sdk.core.configuration.SdkProperties;
import cn.insmart.mp.kuaishou.sdk.core.support.BannerPrinter;
import cn.insmart.mp.kuaishou.sdk.core.support.DefaultApiFactoryManager;
import cn.insmart.mp.kuaishou.sdk.core.token.MysqlTokenProvider;
import cn.insmart.mp.kuaishou.sdk.core.token.MysqlTokenRefresher;
import cn.insmart.mp.kuaishou.sdk.core.token.UnsupportedTokenRefresher;
import cn.insmart.mp.kuaishou.sdk.core.token.YmlTokenProvider;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SdkProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class SdkAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SdkAutoConfiguration.class);

    @Bean
    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnProperty(prefix="app.kuaishou.sdk", value={"token-table-name"})
    TokenProvider dataSourceAccessTokenProvider(SdkProperties properties, DataSource dataSource) {
        log.info("SDK init AccessTokenProvider: {}", (Object)MysqlTokenProvider.class.getSimpleName());
        return new MysqlTokenProvider(properties, dataSource);
    }

    @Bean
    @ConditionalOnMissingBean
    TokenProvider ymlAccessTokenProvider(SdkProperties properties) {
        log.info("SDK init AccessTokenProvider: {}", (Object)YmlTokenProvider.class.getSimpleName());
        return new YmlTokenProvider(properties);
    }

    @Bean
    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnProperty(prefix="app.kuaishou.sdk", name={"auto-refresh-token"}, havingValue="true")
    TokenRefresher dataSourceAccessTokenRefresher(DataSource dataSource, SdkProperties properties) {
        log.info("SDK init AccessTokenRefresher: {}", (Object)MysqlTokenRefresher.class.getSimpleName());
        return new MysqlTokenRefresher(dataSource, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    TokenRefresher unsupportedAccessTokenRefresher() {
        log.info("SDK init AccessTokenRefresher: {}", (Object)UnsupportedTokenRefresher.class.getSimpleName());
        return new UnsupportedTokenRefresher();
    }

    @Bean
    ApiFactoryManager apiFactoryManager(SdkProperties properties, TokenRefresher tokenRefresher, TokenProvider tokenProvider) {
        log.info("SDK init ApiServiceFactoryManager: {}, properties = \n{}", (Object)DefaultApiFactoryManager.class.getSimpleName(), (Object)properties);
        DefaultApiFactoryManager factoryManager = new DefaultApiFactoryManager(tokenProvider, properties, tokenRefresher);
        BannerPrinter.print();
        return factoryManager;
    }
}

