/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.kuaishou.sdk.core.support;

import cn.insmart.fx.common.lang.util.StringUtils;
import cn.insmart.mp.kuaishou.sdk.core.Api;
import cn.insmart.mp.kuaishou.sdk.core.ApiFactory;
import cn.insmart.mp.kuaishou.sdk.core.TokenProvider;
import cn.insmart.mp.kuaishou.sdk.core.TokenRefresher;
import cn.insmart.mp.kuaishou.sdk.core.coder.FieldQueryMapEncoder;
import cn.insmart.mp.kuaishou.sdk.core.coder.FileDownloadDecoder;
import cn.insmart.mp.kuaishou.sdk.core.configuration.SdkProperties;
import cn.insmart.mp.kuaishou.sdk.core.logger.SdkLogger;
import cn.insmart.mp.kuaishou.sdk.core.support.InvocationHandlerFactory;
import cn.insmart.mp.kuaishou.sdk.core.support.LoggerLevelResolver;
import cn.insmart.mp.kuaishou.sdk.core.support.ObjectMappers;
import cn.insmart.mp.kuaishou.sdk.core.support.RequestTemplateUtils;
import feign.Client;
import feign.Feign;
import feign.QueryMapEncoder;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.http2client.Http2Client;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApiFactory
implements ApiFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultApiFactory.class);
    private final SdkProperties.AccountConfiguration accountConfiguration;
    private final SdkProperties sdkProperties;
    private final TokenProvider tokenProvider;
    private final TokenRefresher tokenRefresher;

    public DefaultApiFactory(SdkProperties.AccountConfiguration accountConfiguration, SdkProperties sdkProperties, TokenProvider tokenProvider, TokenRefresher tokenRefresher) {
        this.accountConfiguration = Objects.requireNonNull(accountConfiguration, "AccountConfiguration is null");
        this.sdkProperties = Objects.requireNonNull(sdkProperties, "SdkProperties is null");
        this.tokenProvider = Objects.requireNonNull(tokenProvider, "TokenProvider is null");
        this.tokenRefresher = Objects.requireNonNull(tokenRefresher, "TokenRefresher is null");
    }

    @Override
    public <T extends Api> T create(Class<T> service) {
        if (Objects.nonNull(this.sdkProperties.getProxy()) && StringUtils.isNotBlank((CharSequence)this.sdkProperties.getProxy().getHost()) && this.sdkProperties.getProxy().getPort() > 0) {
            return this.createProxy(service);
        }
        return (T)((Api)Feign.builder().invocationHandlerFactory((feign.InvocationHandlerFactory)new InvocationHandlerFactory(this.sdkProperties, this.accountConfiguration, this.tokenRefresher)).queryMapEncoder((QueryMapEncoder)new FieldQueryMapEncoder()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(ObjectMappers.getMapper()))).decoder((Decoder)new FileDownloadDecoder((Decoder)new JacksonDecoder(ObjectMappers.getMapper()))).client((Client)new Http2Client(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMinutes(2L)).build())).logLevel(LoggerLevelResolver.resolve(this.sdkProperties.getLoggerLevel())).logger((feign.Logger)new SdkLogger(this.sdkProperties)).requestInterceptor(template -> {
            RequestTemplateUtils.jsonContentType(template);
            Long id = this.accountConfiguration.getId();
            String accessToken = this.tokenProvider.getToken(id);
            Objects.requireNonNull(accessToken, () -> String.format("AccessToken \u4e3a\u7a7a, \u7f57\u76d8ID:%s", id));
            template.header("Access-Token", new String[]{accessToken});
        }).target(service, this.sdkProperties.getApi()));
    }

    public <T extends Api> T createProxy(Class<T> service) {
        HttpClient build = HttpClient.newBuilder().proxy(ProxySelector.of(new InetSocketAddress(this.sdkProperties.getProxy().getHost(), this.sdkProperties.getProxy().getPort()))).authenticator(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(DefaultApiFactory.this.sdkProperties.getProxy().getUserName(), DefaultApiFactory.this.sdkProperties.getProxy().getPassWord().toCharArray());
            }
        }).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMinutes(2L)).build();
        return (T)((Api)Feign.builder().invocationHandlerFactory((feign.InvocationHandlerFactory)new InvocationHandlerFactory(this.sdkProperties, this.accountConfiguration, this.tokenRefresher)).queryMapEncoder((QueryMapEncoder)new FieldQueryMapEncoder()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(ObjectMappers.getMapper()))).decoder((Decoder)new FileDownloadDecoder((Decoder)new JacksonDecoder(ObjectMappers.getMapper()))).client((Client)new Http2Client(build)).logLevel(LoggerLevelResolver.resolve(this.sdkProperties.getLoggerLevel())).logger((feign.Logger)new SdkLogger(this.sdkProperties)).requestInterceptor(template -> {
            RequestTemplateUtils.jsonContentType(template);
            Long id = this.accountConfiguration.getId();
            String accessToken = this.tokenProvider.getToken(id);
            Objects.requireNonNull(accessToken, () -> String.format("AccessToken \u4e3a\u7a7a, \u7f57\u76d8ID:%s", id));
            template.header("Access-Token", new String[]{accessToken});
        }).target(service, this.sdkProperties.getApi()));
    }

    protected SdkProperties.AccountConfiguration getAccountConfiguration() {
        return this.accountConfiguration;
    }

    protected SdkProperties getSdkProperties() {
        return this.sdkProperties;
    }

    protected TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    protected TokenRefresher getTokenRefresher() {
        return this.tokenRefresher;
    }
}

