/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.kuaishou.sdk.core.support;

import feign.Logger;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerLevelResolver {
    private static final Logger log = LoggerFactory.getLogger(LoggerLevelResolver.class);

    public static Logger.Level resolve(String levelString) {
        Logger.Level level = (Logger.Level)EnumUtils.getEnum(Logger.Level.class, (String)StringUtils.upperCase((String)levelString));
        if (Objects.isNull(level)) {
            log.error("\u4e0d\u80fd\u89e3\u51b3Feign Logger Level : \u201c{}\u201d, \u4f7f\u7528\u9ed8\u8ba4 {}, \u652f\u6301\u4f7f\u7528\u7684: {}", new Object[]{levelString, Logger.Level.FULL, Stream.of(Logger.Level.values()).map(Enum::name).collect(Collectors.joining(", "))});
            return Logger.Level.FULL;
        }
        return level;
    }
}

