/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.kuaishou.sdk.core.service;

import cn.insmart.mp.kuaishou.sdk.core.AdvertiserRequest;
import cn.insmart.mp.kuaishou.sdk.core.Api;
import cn.insmart.mp.kuaishou.sdk.core.dto.DetailResponse;
import cn.insmart.mp.kuaishou.sdk.core.dto.Response;
import cn.insmart.mp.kuaishou.sdk.core.support.DefaultAdvertiserRequest;
import cn.insmart.mp.kuaishou.sdk.core.support.PageExecutor;
import cn.insmart.mp.kuaishou.sdk.dto.AdvertiserDailyFlows;
import cn.insmart.mp.kuaishou.sdk.dto.AdvertiserDailyFlowsRequest;
import cn.insmart.mp.kuaishou.sdk.dto.AdvertiserFund;
import cn.insmart.mp.kuaishou.sdk.dto.AdvertiserInfo;
import feign.RequestLine;
import java.util.List;

public interface AdvertiserApi
extends Api {
    @RequestLine(value="POST /v1/advertiser/info")
    public Response<AdvertiserInfo> info(AdvertiserRequest var1);

    @RequestLine(value="POST /v1/advertiser/fund/get")
    public Response<AdvertiserFund> fund(AdvertiserRequest var1);

    @RequestLine(value="POST /v1/advertiser/fund/daily_flows")
    public DetailResponse<AdvertiserDailyFlows> dailyFlows(AdvertiserDailyFlowsRequest var1);

    default public AdvertiserInfo info(Long advertiserId) {
        return this.info(new DefaultAdvertiserRequest(advertiserId)).check().getData();
    }

    default public List<AdvertiserDailyFlows> dailyFlowsData(AdvertiserDailyFlowsRequest request) {
        return PageExecutor.executor(request, this::dailyFlows);
    }

    default public AdvertiserFund fund(Long advertiserId) {
        return this.fund(new DefaultAdvertiserRequest(advertiserId)).check().getData();
    }

    default public List<AdvertiserDailyFlows> dailyFlows(Long advertiserId) {
        AdvertiserDailyFlowsRequest req = new AdvertiserDailyFlowsRequest();
        req.setAdvertiserId(advertiserId);
        return PageExecutor.executor(req, this::dailyFlows);
    }
}

