/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.kuaishou.sdk.core.support;

import cn.insmart.mp.kuaishou.sdk.core.ApiFactory;
import cn.insmart.mp.kuaishou.sdk.core.ApiFactoryManager;
import cn.insmart.mp.kuaishou.sdk.core.TokenProvider;
import cn.insmart.mp.kuaishou.sdk.core.TokenRefresher;
import cn.insmart.mp.kuaishou.sdk.core.configuration.SdkProperties;
import cn.insmart.mp.kuaishou.sdk.core.dto.Advertiser;
import cn.insmart.mp.kuaishou.sdk.core.exception.AccessTokenErrorException;
import cn.insmart.mp.kuaishou.sdk.core.service.CompassApi;
import cn.insmart.mp.kuaishou.sdk.core.support.DefaultApiFactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApiFactoryManager
implements ApiFactoryManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultApiFactoryManager.class);
    private final Map<Long, ApiFactory> accountIdApiFactoryMap = new ConcurrentHashMap<Long, ApiFactory>();
    private final TokenProvider tokenProvider;
    private final SdkProperties sdkProperties;
    private final TokenRefresher refreshAccessToken;
    private final Map<Long, SdkProperties.AccountConfiguration> accountPropertiesMap;
    private final Map<Long, List<Advertiser>> accountAdvertiserMap = new ConcurrentHashMap<Long, List<Advertiser>>();
    private final Map<Long, Advertiser> advertiserInfoMap = new ConcurrentHashMap<Long, Advertiser>();
    private final Map<Long, Long> advertiserIdMap = new ConcurrentHashMap<Long, Long>();
    private boolean init;

    public DefaultApiFactoryManager(TokenProvider tokenProvider, SdkProperties sdkProperties, TokenRefresher refreshAccessToken) {
        this.tokenProvider = Objects.requireNonNull(tokenProvider, "AccessTokenProvider is null");
        this.sdkProperties = Objects.requireNonNull(sdkProperties, "SdkProperties is null");
        this.refreshAccessToken = Objects.requireNonNull(refreshAccessToken, "AccessTokenRefresher is null");
        this.accountPropertiesMap = sdkProperties.getAccountConfigurations().stream().collect(Collectors.toUnmodifiableMap(SdkProperties.AccountConfiguration::getId, Function.identity()));
        this.init(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public ApiFactory getApiFactory(Long advertiserId) {
        Long kuaishouAccountId;
        if (this.accountPropertiesMap.containsKey(advertiserId)) {
            log.info("getApiFactory account {}", (Object)advertiserId);
            kuaishouAccountId = advertiserId;
            return this.accountIdApiFactoryMap.computeIfAbsent(kuaishouAccountId, id -> new DefaultApiFactory(this.accountPropertiesMap.get(id), this.sdkProperties, this.tokenProvider, this.refreshAccessToken));
        }
        kuaishouAccountId = this.advertiserIdMap.get(advertiserId);
        if (Objects.isNull(kuaishouAccountId)) {
            Class<DefaultApiFactoryManager> clazz = DefaultApiFactoryManager.class;
            // MONITORENTER : cn.insmart.mp.kuaishou.sdk.core.support.DefaultApiFactoryManager.class
            kuaishouAccountId = this.advertiserIdMap.get(advertiserId);
            if (Objects.isNull(kuaishouAccountId)) {
                this.init(true);
                kuaishouAccountId = this.advertiserIdMap.get(advertiserId);
            }
            // MONITOREXIT : clazz
        }
        Objects.requireNonNull(kuaishouAccountId, () -> String.format("\u8d26\u53f7ID = %s \u627e\u4e0d\u5230\u7f57\u76d8ID, IdMap= %s, compassAdvertiserInfoMap = %s", advertiserId, this.advertiserIdMap, this.accountAdvertiserMap));
        log.info("getApiFactory advertiser {} -> {}", (Object)advertiserId, (Object)kuaishouAccountId);
        return this.accountIdApiFactoryMap.computeIfAbsent(kuaishouAccountId, id -> new DefaultApiFactory(this.accountPropertiesMap.get(id), this.sdkProperties, this.tokenProvider, this.refreshAccessToken));
    }

    @Override
    public Advertiser getAdvertiserInfo(Long advertiserId) {
        if (!this.init) {
            this.init(true);
        }
        return this.advertiserInfoMap.get(advertiserId);
    }

    @Override
    public SdkProperties getSdkProperties() {
        return this.sdkProperties;
    }

    private synchronized void init(boolean isThrow) {
        try {
            for (SdkProperties.AccountConfiguration accountConfiguration : this.getAccountConfigurations()) {
                Long id = accountConfiguration.getId();
                ApiFactory factory = this.getApiFactory(id);
                CompassApi compassService = factory.create(CompassApi.class);
                List<cn.insmart.mp.kuaishou.sdk.dto.Advertiser> advertisers = compassService.advertisers();
                List accounts = advertisers.stream().map(advertiser -> new Advertiser(id, advertiser.getAdvertiserId(), advertiser.getAdvertiserName())).collect(Collectors.toList());
                this.advertiserIdMap.putAll(accounts.stream().collect(Collectors.toMap(Advertiser::getAdvertiserId, Advertiser::getAccountId)));
                this.accountAdvertiserMap.put(id, accounts);
                this.advertiserInfoMap.putAll(accounts.stream().collect(Collectors.toMap(Advertiser::getAdvertiserId, Function.identity())));
                if (!log.isInfoEnabled()) continue;
                log.info("SDK init \u7f57\u76d8\u8d26\u53f7:{}, \u5b50\u8d26\u53f7\u5217\u8868({}): {}", new Object[]{id, accounts.size(), accounts.stream().collect(Collectors.toMap(Advertiser::getAdvertiserId, Advertiser::getAdvertiserName))});
            }
            this.init = true;
        }
        catch (AccessTokenErrorException e) {
            if (isThrow) {
                throw e;
            }
            System.err.println(String.format("Token\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5" + e.getMessage(), new Object[0]));
            log.error("\u8bf7\u68c0\u67e5\u914d\u7f6e\u7684Token\u662f\u5426\u6b63\u786e, {}", (Object)e.getMessage());
        }
    }

    public String toString() {
        return "DefaultApiFactoryManager{sdkProperties=" + this.sdkProperties + ", accountIdApiFactoryMap=" + this.accountIdApiFactoryMap + ", accountPropertiesMap=" + this.accountPropertiesMap + ", accountAdvertiserMap=" + this.accountAdvertiserMap + ", advertiserInfoMap=" + this.advertiserInfoMap + ", advertiserIdMap=" + this.advertiserIdMap + ", init=" + this.init + "}";
    }
}

