/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.kuaishou.sdk.core.dto;

import cn.insmart.mp.kuaishou.sdk.core.dto.DataDetail;
import cn.insmart.mp.kuaishou.sdk.core.dto.Response;
import java.beans.Transient;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DetailResponse<T>
extends Response<DataDetail<T>> {
    @Transient
    public List<T> list() {
        Supplier<List> supplier = Collections::emptyList;
        return Optional.ofNullable((DataDetail)this.data).map(e -> Objects.requireNonNullElseGet(e.getDetails(), supplier)).orElseGet(supplier);
    }

    @Override
    @Transient
    public DetailResponse<T> check() {
        return (DetailResponse)super.check();
    }

    @Transient
    public boolean isReturn() {
        return this.list().isEmpty() || this.list().size() == ((DataDetail)this.data).getTotalCount().intValue() || ((DataDetail)this.data).getTotalCount() == 0;
    }

    public <R> DetailResponse<R> convert(Function<? super T, ? extends R> mapper) {
        List<T> list = this.list();
        if (Objects.isNull(list)) {
            return this;
        }
        DataDetail data = (DataDetail)this.getData();
        data.setDetails(list.stream().map(mapper).collect(Collectors.toList()));
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetailResponse)) {
            return false;
        }
        DetailResponse other = (DetailResponse)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DetailResponse;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    public String toString() {
        return "DetailResponse(super=" + super.toString() + ")";
    }
}

