/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.kuaishou.sdk.core.token;

import cn.insmart.mp.kuaishou.sdk.core.TokenProvider;
import cn.insmart.mp.kuaishou.sdk.core.configuration.SdkProperties;
import cn.insmart.mp.kuaishou.sdk.core.exception.AccessTokeException;
import cn.insmart.mp.kuaishou.sdk.core.exception.AccessTokenNotFindException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlTokenProvider
implements TokenProvider {
    private static final Logger log = LoggerFactory.getLogger(MysqlTokenProvider.class);
    private final DataSource dataSource;
    private final SdkProperties properties;

    public MysqlTokenProvider(SdkProperties properties, DataSource dataSource) {
        this.properties = Objects.requireNonNull(properties, "properties is null");
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getToken(Long kuaishouAccountId) throws AccessTokenNotFindException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(String.format("select access_token from %s where id=?", this.properties.getTokenTableName()));){
            ps.setLong(1, kuaishouAccountId);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) throw new AccessTokenNotFindException("\u6ca1\u627e\u5230\u5e7f\u544a\u4e3b\u7684token, advertiserId = " + kuaishouAccountId, new Object[0]);
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            throw new AccessTokeException(e);
        }
    }
}

