/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.kuaishou.sdk.core.service.v2;

import cn.insmart.mp.kuaishou.sdk.bean.Campaign;
import cn.insmart.mp.kuaishou.sdk.core.Api;
import cn.insmart.mp.kuaishou.sdk.core.annotation.QpsLimit;
import cn.insmart.mp.kuaishou.sdk.core.dto.DetailResponse;
import cn.insmart.mp.kuaishou.sdk.core.dto.Response;
import cn.insmart.mp.kuaishou.sdk.core.support.PageExecutor;
import cn.insmart.mp.kuaishou.sdk.dto.CampaignAddRequest;
import cn.insmart.mp.kuaishou.sdk.dto.CampaignRequest;
import feign.RequestLine;
import java.util.List;
import org.springframework.beans.BeanUtils;

public interface V2CampaignApi
extends Api {
    @QpsLimit(value=10)
    @RequestLine(value="POST /gw/dsp/campaign/list")
    public DetailResponse<CampaignEx> listEx(CampaignRequest var1);

    @RequestLine(value="POST /gw/dsp/campaign/create")
    public Response<Campaign> create(Campaign var1);

    @RequestLine(value="POST /gw/dsp/campaign/update")
    public Response<Campaign> update(CampaignAddRequest var1);

    default public DetailResponse<Campaign> list(CampaignRequest request) {
        return this.listEx(request).convert(ex -> {
            Campaign campaign = new Campaign();
            BeanUtils.copyProperties((Object)ex, (Object)campaign);
            campaign.setType(ex.getCampaignType());
            campaign.setSubType(ex.getCampaignSubType());
            return campaign;
        });
    }

    default public List<Campaign> listData(CampaignRequest request) {
        return PageExecutor.executor(request, this::list);
    }

    default public List<Campaign> list(Long advertiserId) {
        CampaignRequest req = new CampaignRequest();
        req.setAdvertiserId(advertiserId);
        return this.listData(req);
    }

    public static class CampaignEx
    extends Campaign {
        private Integer campaignType;
        private Integer campaignSubType;

        public Integer getCampaignType() {
            return this.campaignType;
        }

        public Integer getCampaignSubType() {
            return this.campaignSubType;
        }

        public void setCampaignType(Integer campaignType) {
            this.campaignType = campaignType;
        }

        public void setCampaignSubType(Integer campaignSubType) {
            this.campaignSubType = campaignSubType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CampaignEx)) {
                return false;
            }
            CampaignEx other = (CampaignEx)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            Integer this$campaignType = this.getCampaignType();
            Integer other$campaignType = other.getCampaignType();
            if (this$campaignType == null ? other$campaignType != null : !((Object)this$campaignType).equals(other$campaignType)) {
                return false;
            }
            Integer this$campaignSubType = this.getCampaignSubType();
            Integer other$campaignSubType = other.getCampaignSubType();
            return !(this$campaignSubType == null ? other$campaignSubType != null : !((Object)this$campaignSubType).equals(other$campaignSubType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CampaignEx;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $campaignType = this.getCampaignType();
            result = result * 59 + ($campaignType == null ? 43 : ((Object)$campaignType).hashCode());
            Integer $campaignSubType = this.getCampaignSubType();
            result = result * 59 + ($campaignSubType == null ? 43 : ((Object)$campaignSubType).hashCode());
            return result;
        }

        public String toString() {
            return "V2CampaignApi.CampaignEx(campaignType=" + this.getCampaignType() + ", campaignSubType=" + this.getCampaignSubType() + ")";
        }
    }
}

