/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.kuaishou.sdk.core.support;

import cn.insmart.mp.kuaishou.sdk.core.TokenRefresher;
import cn.insmart.mp.kuaishou.sdk.core.configuration.SdkProperties;
import cn.insmart.mp.kuaishou.sdk.core.exception.AccessTokenExpiredException;
import cn.insmart.mp.kuaishou.sdk.core.support.CodeChecker;
import cn.insmart.mp.kuaishou.sdk.core.support.DefaultApiEnvironment;
import cn.insmart.mp.kuaishou.sdk.core.support.QpsLimiter;
import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InvocationHandlerFactory
implements feign.InvocationHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(InvocationHandlerFactory.class);
    private static final String GET_ENVIRONMENT_METHOD = "getEnvironment";
    private final SdkProperties sdkProperties;
    private final SdkProperties.AccountConfiguration accountConfiguration;
    private final TokenRefresher tokenRefresher;

    public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        return new InvocationHandler(target, dispatch);
    }

    public InvocationHandlerFactory(SdkProperties sdkProperties, SdkProperties.AccountConfiguration accountConfiguration, TokenRefresher tokenRefresher) {
        this.sdkProperties = sdkProperties;
        this.accountConfiguration = accountConfiguration;
        this.tokenRefresher = tokenRefresher;
    }

    public SdkProperties getSdkProperties() {
        return this.sdkProperties;
    }

    public SdkProperties.AccountConfiguration getAccountConfiguration() {
        return this.accountConfiguration;
    }

    public TokenRefresher getTokenRefresher() {
        return this.tokenRefresher;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvocationHandlerFactory)) {
            return false;
        }
        InvocationHandlerFactory other = (InvocationHandlerFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SdkProperties this$sdkProperties = this.getSdkProperties();
        SdkProperties other$sdkProperties = other.getSdkProperties();
        if (this$sdkProperties == null ? other$sdkProperties != null : !((Object)this$sdkProperties).equals(other$sdkProperties)) {
            return false;
        }
        SdkProperties.AccountConfiguration this$accountConfiguration = this.getAccountConfiguration();
        SdkProperties.AccountConfiguration other$accountConfiguration = other.getAccountConfiguration();
        if (this$accountConfiguration == null ? other$accountConfiguration != null : !((Object)this$accountConfiguration).equals(other$accountConfiguration)) {
            return false;
        }
        TokenRefresher this$tokenRefresher = this.getTokenRefresher();
        TokenRefresher other$tokenRefresher = other.getTokenRefresher();
        return !(this$tokenRefresher == null ? other$tokenRefresher != null : !this$tokenRefresher.equals(other$tokenRefresher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvocationHandlerFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SdkProperties $sdkProperties = this.getSdkProperties();
        result = result * 59 + ($sdkProperties == null ? 43 : ((Object)$sdkProperties).hashCode());
        SdkProperties.AccountConfiguration $accountConfiguration = this.getAccountConfiguration();
        result = result * 59 + ($accountConfiguration == null ? 43 : ((Object)$accountConfiguration).hashCode());
        TokenRefresher $tokenRefresher = this.getTokenRefresher();
        result = result * 59 + ($tokenRefresher == null ? 43 : $tokenRefresher.hashCode());
        return result;
    }

    public String toString() {
        return "InvocationHandlerFactory(sdkProperties=" + this.getSdkProperties() + ", accountConfiguration=" + this.getAccountConfiguration() + ", tokenRefresher=" + this.getTokenRefresher() + ")";
    }

    class InvocationHandler
    implements java.lang.reflect.InvocationHandler {
        private final Target target;
        private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.isDefault()) {
                if (InvocationHandlerFactory.GET_ENVIRONMENT_METHOD.equals(method.getName()) && method.getParameterCount() == 0) {
                    return new DefaultApiEnvironment(InvocationHandlerFactory.this.sdkProperties, InvocationHandlerFactory.this.accountConfiguration);
                }
                Class<?> declaringClass = method.getDeclaringClass();
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(declaringClass, MethodHandles.lookup());
                MethodHandle special = lookup.findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass);
                return special.bindTo(proxy).invokeWithArguments(args);
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke(proxy, args);
            }
            QpsLimiter.limit(method);
            Objects.requireNonNull(args, "\u63a5\u53e3\u65b9\u6cd5\u5fc5\u987b\u6709\u53c2\u6570\u5b9a\u4e49");
            int i = 0;
            while (true) {
                try {
                    return CodeChecker.check(this.dispatch.get(method).invoke(args), args);
                }
                catch (AccessTokenExpiredException e) {
                    InvocationHandlerFactory.this.tokenRefresher.refresh(InvocationHandlerFactory.this.accountConfiguration.getId());
                    return CodeChecker.check(this.dispatch.get(method).invoke(args), args);
                }
                catch (FeignException.GatewayTimeout e) {
                    if (i > InvocationHandlerFactory.this.sdkProperties.getTimeoutRetry()) {
                        throw e;
                    }
                    log.info("\u7f51\u5173\u8d85\u65f6 \u5c1d\u8bd5\u6b21\u6570: {} {}", (Object)i, (Object)e.getMessage());
                    ++i;
                    continue;
                }
                break;
            }
        }

        public InvocationHandler(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
            this.target = target;
            this.dispatch = dispatch;
        }

        public Target getTarget() {
            return this.target;
        }

        public Map<Method, InvocationHandlerFactory.MethodHandler> getDispatch() {
            return this.dispatch;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvocationHandler)) {
                return false;
            }
            InvocationHandler other = (InvocationHandler)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Target this$target = this.getTarget();
            Target other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            Map<Method, InvocationHandlerFactory.MethodHandler> this$dispatch = this.getDispatch();
            Map<Method, InvocationHandlerFactory.MethodHandler> other$dispatch = other.getDispatch();
            return !(this$dispatch == null ? other$dispatch != null : !((Object)this$dispatch).equals(other$dispatch));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InvocationHandler;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Target $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            Map<Method, InvocationHandlerFactory.MethodHandler> $dispatch = this.getDispatch();
            result = result * 59 + ($dispatch == null ? 43 : ((Object)$dispatch).hashCode());
            return result;
        }

        public String toString() {
            return "InvocationHandlerFactory.InvocationHandler(target=" + this.getTarget() + ", dispatch=" + this.getDispatch() + ")";
        }
    }
}

