/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.kuaishou.sdk.core.service;

import cn.hutool.core.thread.ThreadUtil;
import cn.insmart.mp.kuaishou.sdk.bean.AsyncTask;
import cn.insmart.mp.kuaishou.sdk.core.Api;
import cn.insmart.mp.kuaishou.sdk.core.dto.DetailResponse;
import cn.insmart.mp.kuaishou.sdk.core.dto.Response;
import cn.insmart.mp.kuaishou.sdk.core.exception.SdkTaskFailException;
import cn.insmart.mp.kuaishou.sdk.core.exception.SdkTaskTimeoutException;
import cn.insmart.mp.kuaishou.sdk.dto.AsyncTaskCreateRequest;
import cn.insmart.mp.kuaishou.sdk.dto.AsyncTaskQueryRequest;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public interface AsyncTaskApi
extends Api {
    @RequestLine(value="POST /v1/async_task/create")
    public Response<AsyncTask> create(AsyncTaskCreateRequest var1);

    @RequestLine(value="POST /v1/async_task/list")
    public DetailResponse<AsyncTask> list(AsyncTaskQueryRequest var1);

    default public AsyncTask get(AsyncTask task) {
        AsyncTaskQueryRequest request = new AsyncTaskQueryRequest(Objects.requireNonNull(task.getAdvertiserId(), "advertiserId is null"), Objects.requireNonNull(task.getTaskId(), "taskId is null"));
        DetailResponse<AsyncTask> list = this.list(request);
        return list.list().get(0);
    }

    @Headers(value={"Content-Type: */*"})
    @RequestLine(value="GET /v1/async_task/download?advertiser_id={advertiserId}&task_id={taskId}")
    public File download(@Param(value="advertiserId") Long var1, @Param(value="taskId") Long var2);

    default public File createAndAwait(AsyncTaskCreateRequest request) {
        AsyncTask task = this.create(request).getData();
        int i = 0;
        while (true) {
            ThreadUtil.sleep((Number)10, (TimeUnit)TimeUnit.SECONDS);
            task = this.get(task);
            if (3 == task.getTaskStatus()) {
                throw new SdkTaskFailException(task.toString(), new Object[0]);
            }
            if (2 == task.getTaskStatus()) {
                if (task.getFileSize() == 0) {
                    return null;
                }
                return this.download(task.getAdvertiserId(), task.getTaskId());
            }
            if (i > 60) {
                throw new SdkTaskTimeoutException("\u8d85\u65f6 %s", task);
            }
            ++i;
        }
    }
}

