/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.kuaishou.sdk.core.token;

import cn.insmart.mp.kuaishou.sdk.core.Authorize;
import cn.insmart.mp.kuaishou.sdk.core.TokenRefresher;
import cn.insmart.mp.kuaishou.sdk.core.coder.FieldQueryMapEncoder;
import cn.insmart.mp.kuaishou.sdk.core.configuration.SdkProperties;
import cn.insmart.mp.kuaishou.sdk.core.exception.AccessTokenRefreshException;
import cn.insmart.mp.kuaishou.sdk.core.logger.SdkLogger;
import cn.insmart.mp.kuaishou.sdk.core.support.CodeChecker;
import cn.insmart.mp.kuaishou.sdk.core.support.LoggerLevelResolver;
import cn.insmart.mp.kuaishou.sdk.core.support.ObjectMappers;
import cn.insmart.mp.kuaishou.sdk.core.support.RequestTemplateUtils;
import cn.insmart.mp.kuaishou.sdk.dto.Token;
import cn.insmart.mp.kuaishou.sdk.dto.TokenRequest;
import feign.Client;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.QueryMapEncoder;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.http2client.Http2Client;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.net.http.HttpClient;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlTokenRefresher
implements TokenRefresher {
    private static final Logger log = LoggerFactory.getLogger(MysqlTokenRefresher.class);
    private final DataSource dataSource;
    private final SdkProperties properties;

    public MysqlTokenRefresher(DataSource dataSource, SdkProperties properties) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        this.properties = Objects.requireNonNull(properties, "properties is null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean refresh(Long kuaishouAccountId) throws AccessTokenRefreshException {
        String table = this.properties.getTokenTableName();
        LocalDateTime now = LocalDateTime.now();
        log.info("kuaishouSdk refreshToken {}, {}", (Object)kuaishouAccountId, (Object)table);
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement(String.format("select app_id, secret, refresh_token from %s where id=? and update_time<? for update", table));){
                statement.setLong(1, kuaishouAccountId);
                statement.setObject(2, now.minusMinutes(5L));
                try (ResultSet resultSet = statement.executeQuery();){
                    if (!resultSet.next()) return false;
                    TokenRequest request = new TokenRequest();
                    request.setAppId(Long.valueOf(resultSet.getLong("app_id")));
                    request.setSecret(resultSet.getString("secret"));
                    request.setRefreshToken(resultSet.getString("refresh_token"));
                    Token data = this.createApi().refreshToken(request).getData();
                    PreparedStatement preparedStatement = connection.prepareStatement(String.format("update %s set access_token=?, refresh_token=?, update_time=? where id=?", table));
                    preparedStatement.setString(1, data.getAccessToken());
                    preparedStatement.setString(2, data.getRefreshToken());
                    preparedStatement.setObject(3, now);
                    preparedStatement.setLong(4, kuaishouAccountId);
                    preparedStatement.executeUpdate();
                    connection.commit();
                    log.info("kuaishouSdk \u5237\u65b0Token\u6210\u529f, \u7f57\u76d8\u8d26\u53f7ID: {}", (Object)kuaishouAccountId);
                    Boolean bl = true;
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            log.error("kuaishouSdk error {}", (Object)e.getMessage());
            throw new AccessTokenRefreshException("\u5237\u65b0token\u9519\u8bef\uff1a%s", kuaishouAccountId, e);
        }
    }

    private Authorize createApi() {
        return (Authorize)Feign.builder().invocationHandlerFactory((target, dispatch) -> (proxy, method, args) -> CodeChecker.check(((InvocationHandlerFactory.MethodHandler)dispatch.get(method)).invoke(args), args)).requestInterceptor(RequestTemplateUtils::jsonContentType).queryMapEncoder((QueryMapEncoder)new FieldQueryMapEncoder()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(ObjectMappers.getMapper()))).decoder((Decoder)new JacksonDecoder(ObjectMappers.getMapper())).client((Client)new Http2Client(HttpClient.newBuilder().build())).logger((feign.Logger)new SdkLogger(this.properties)).logLevel(LoggerLevelResolver.resolve(this.properties.getLoggerLevel())).target(Authorize.class, this.properties.getApi());
    }
}

