/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.media.common.enums;

import cn.insmart.mp.media.common.support.WordPacket;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum VariableEnum implements WordPacket
{
    BRAND("\u54c1\u724c"),
    MANUFACTURER("\u5382\u5546"),
    SERIAL("\u8f66\u7cfb"),
    TODAY("\u4eca\u5929"),
    WEEKEND("\u5468\u672b"),
    MONTH("\u6708\u4efd"),
    YEAR("\u5e74"),
    SHORT_YEAR("\u77ed\u5e74"),
    DOWN_PAYMENT("\u9996\u4ed8");

    public final String key;
    public final String hold;

    private VariableEnum(String key) {
        this.key = key;
        this.hold = String.format("${%s}", key);
    }

    public static Set<WordPacket> getWordPackets() {
        return Stream.of(VariableEnum.values()).map(WordPacket.DefaultWordPacket::new).collect(Collectors.toSet());
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getHold() {
        return this.hold;
    }
}

