/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.media.common.support;

import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Size {
    private final int width;
    private final int height;
    private final BigDecimal scale;

    public static Size of(int width, int height) {
        return new Size(width, height);
    }

    public static Size of(BufferedImage bufferedImage) {
        return Size.of(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    Size(int width, int height) {
        if (width <= 0) {
            throw new IllegalArgumentException("width \u5c0f\u4e8e 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("height \u5c0f\u4e8e 0");
        }
        this.width = width;
        this.height = height;
        this.scale = BigDecimal.valueOf(width).divide(BigDecimal.valueOf(height), 4, RoundingMode.HALF_UP);
    }

    public String getSpecification() {
        return String.format("%sx%s", this.width, this.height);
    }

    public String toString() {
        return String.format("[ width = %s, height = %s, width/height = %s ]", this.width, this.height, this.scale);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BigDecimal getScale() {
        return this.scale;
    }
}

