/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.media.common.support;

import cn.insmart.fx.video.common.baen.VideoInfo;
import cn.insmart.mp.media.common.support.Size;
import java.io.File;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SpecificationsDefinition {
    public boolean match(VideoInfo var1, File var2);

    public boolean match(Size var1, File var2);

    public Range<Integer> getWidth();

    public Range<Integer> getHeight();

    public BigDecimal getScale();

    public static class Default
    implements SpecificationsDefinition {
        private static final Logger log = LoggerFactory.getLogger(Default.class);
        protected final Double size;
        protected final BigDecimal scale;
        protected final Range<Integer> width;
        protected final Range<Integer> height;
        protected final Collection<String> suffixs;
        protected final Integer bitRate;
        protected final Integer audioRitRate;
        protected final Integer frameRate;

        @Override
        public boolean match(Size size, File file) {
            Objects.requireNonNull(size, "size is null");
            if (!(Objects.equals(this.width.getMinimum(), size.getWidth()) && Objects.equals(this.height.getMinimum(), size.getHeight()) || Objects.equals(this.width.getMaximum(), size.getWidth()) && Objects.equals(this.height.getMaximum(), size.getHeight()))) {
                if (!this.width.contains((Object)size.getWidth())) {
                    return false;
                }
                if (!this.height.contains((Object)size.getHeight())) {
                    return false;
                }
                if (Objects.nonNull(this.scale) && !size.getScale().equals(this.scale)) {
                    return false;
                }
            }
            if (CollectionUtils.isNotEmpty(this.suffixs) && !this.suffixs.contains(StringUtils.lowerCase((String)FilenameUtils.getExtension((String)file.getName())))) {
                return false;
            }
            if (Objects.nonNull(this.size) && Objects.nonNull(file) && (double)file.length() >= this.size * 1024.0 * 1024.0) {
                log.info("\u65e5\u5fd7\u6253\u5370\uff1a{}", (Object)file.length());
                return false;
            }
            return true;
        }

        @Override
        public boolean match(VideoInfo videoInfo, File file) {
            double fileSize;
            if (Objects.isNull(this.size) && (fileSize = videoInfo.getFileSize()) > this.size) {
                return false;
            }
            if (!this.match(Size.of(videoInfo.getWidth(), videoInfo.getHeight()), file)) {
                return false;
            }
            if (Objects.nonNull(this.bitRate) && this.bitRate > videoInfo.getBitRate()) {
                return false;
            }
            if (Objects.nonNull(this.audioRitRate) && this.audioRitRate > videoInfo.getAudioMetadata().getBitRate() / 1000) {
                return false;
            }
            return !Objects.nonNull(this.frameRate) || this.frameRate <= videoInfo.getFrameRate();
        }

        public String toString() {
            return String.format("\u3010 \u6587\u4ef6\u5927\u5c0f: %s MB, \u957f\u5bbd\u6bd4\u4f8b: %s, \u957f\u5ea6\u8303\u56f4: %s, \u9ad8\u5ea6\u8303\u56f4: %s, \u652f\u6301\u540e\u7f00\u6587\u4ef6: %s \u3011", this.size, this.scale, this.width, this.height, this.suffixs);
        }

        Default(Double size, BigDecimal scale, Range<Integer> width, Range<Integer> height, Collection<String> suffixs, Integer bitRate, Integer audioRitRate, Integer frameRate) {
            this.size = size;
            this.scale = scale;
            this.width = width;
            this.height = height;
            this.suffixs = suffixs;
            this.bitRate = bitRate;
            this.audioRitRate = audioRitRate;
            this.frameRate = frameRate;
        }

        public static DefaultBuilder builder() {
            return new DefaultBuilder();
        }

        public Double getSize() {
            return this.size;
        }

        @Override
        public BigDecimal getScale() {
            return this.scale;
        }

        @Override
        public Range<Integer> getWidth() {
            return this.width;
        }

        @Override
        public Range<Integer> getHeight() {
            return this.height;
        }

        public Collection<String> getSuffixs() {
            return this.suffixs;
        }

        public Integer getBitRate() {
            return this.bitRate;
        }

        public Integer getAudioRitRate() {
            return this.audioRitRate;
        }

        public Integer getFrameRate() {
            return this.frameRate;
        }

        public static class DefaultBuilder {
            private Double size;
            private BigDecimal scale;
            private Range<Integer> width;
            private Range<Integer> height;
            private Collection<String> suffixs;
            private Integer bitRate;
            private Integer audioRitRate;
            private Integer frameRate;

            DefaultBuilder() {
            }

            public DefaultBuilder size(Double size) {
                this.size = size;
                return this;
            }

            public DefaultBuilder scale(BigDecimal scale) {
                this.scale = scale;
                return this;
            }

            public DefaultBuilder width(Range<Integer> width) {
                this.width = width;
                return this;
            }

            public DefaultBuilder height(Range<Integer> height) {
                this.height = height;
                return this;
            }

            public DefaultBuilder suffixs(Collection<String> suffixs) {
                this.suffixs = suffixs;
                return this;
            }

            public DefaultBuilder bitRate(Integer bitRate) {
                this.bitRate = bitRate;
                return this;
            }

            public DefaultBuilder audioRitRate(Integer audioRitRate) {
                this.audioRitRate = audioRitRate;
                return this;
            }

            public DefaultBuilder frameRate(Integer frameRate) {
                this.frameRate = frameRate;
                return this;
            }

            public Default build() {
                return new Default(this.size, this.scale, this.width, this.height, this.suffixs, this.bitRate, this.audioRitRate, this.frameRate);
            }

            public String toString() {
                return "SpecificationsDefinition.Default.DefaultBuilder(size=" + this.size + ", scale=" + this.scale + ", width=" + this.width + ", height=" + this.height + ", suffixs=" + this.suffixs + ", bitRate=" + this.bitRate + ", audioRitRate=" + this.audioRitRate + ", frameRate=" + this.frameRate + ")";
            }
        }
    }
}

