/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.api.facade.v1;

import cn.insmart.mp.base.enums.Application;
import cn.insmart.mp.toutiao.api.facade.v1.filter.CreativeMaterialGetFilter;
import cn.insmart.mp.toutiao.api.facade.v1.filter.IdsFilter;
import cn.insmart.mp.toutiao.api.facade.v1.request.dto.CreativeSaveDto;
import cn.insmart.mp.toutiao.api.facade.v1.request.dto.RejectReasonDto;
import cn.insmart.mp.toutiao.api.facade.v1.response.dto.CreativeCustomSaveData;
import cn.insmart.mp.toutiao.api.facade.v1.response.dto.CreativeGetData;
import cn.insmart.mp.toutiao.api.facade.v1.response.dto.CreativeMaterialGetData;
import cn.insmart.mp.toutiao.api.facade.v1.response.dto.CreativeRejectReasonData;
import cn.insmart.mp.toutiao.api.facade.v1.response.dto.EmptyResultData;
import cn.insmart.mp.toutiao.api.facade.v1.response.dto.ResponseVO;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@FeignClient(name="is-mp-toutiao", path="/rpc/v1/creatives", url="${service.direct-url.is-mp-toutiao:}", contextId="mpToutiaoCreativeFacade", primary=false)
public interface CreativeFacade {
    public static final String PATH = "/rpc/v1/creatives";

    @ResponseBody
    @GetMapping(value={"/{application}/{ttAdvertiserId}"})
    public ResponseVO<CreativeGetData> getCreative(@Nonnull @PathVariable Application var1, @Nonnull @PathVariable(value="ttAdvertiserId") Long var2, @Nonnull @RequestBody IdsFilter var3);

    @ResponseBody
    @GetMapping(value={"/materials/{application}/{ttAdvertiserId}"})
    public ResponseVO<CreativeMaterialGetData> getCreativeMaterial(@Nonnull @PathVariable Application var1, @Nonnull @PathVariable(value="ttAdvertiserId") Long var2, @Nonnull @RequestBody CreativeMaterialGetFilter var3);

    @ResponseBody
    @PostMapping(value={"/{application}/{ttAdvertiserId}/customer"})
    public ResponseVO<CreativeCustomSaveData> createCustomer(@PathVariable(value="application") Application var1, @PathVariable(value="ttAdvertiserId") Long var2, @RequestBody CreativeSaveDto var3);

    @ResponseBody
    @PutMapping(value={"/{application}/{ttAdvertiserId}/customer"})
    public ResponseVO<CreativeCustomSaveData> updateCustomer(@PathVariable(value="application") Application var1, @PathVariable(value="ttAdvertiserId") Long var2, @RequestBody CreativeSaveDto var3);

    @ResponseBody
    @PostMapping(value={"/{application}/{ttAdvertiserId}/procedural"})
    public ResponseVO<EmptyResultData> createProcedural(@PathVariable(value="application") Application var1, @PathVariable(value="ttAdvertiserId") Long var2, @RequestBody CreativeSaveDto var3);

    @ResponseBody
    @PutMapping(value={"/{application}/{ttAdvertiserId}/procedural"})
    public ResponseVO<EmptyResultData> updateProcedural(@PathVariable(value="application") Application var1, @PathVariable(value="ttAdvertiserId") Long var2, @RequestBody CreativeSaveDto var3);

    @ResponseBody
    @PutMapping(value={"/getRejectReason"})
    public List<CreativeRejectReasonData> getRejectReason(@RequestBody RejectReasonDto var1);
}

