/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.api.facade.v1.response.dto;

import cn.insmart.mp.toutiao.api.facade.v1.response.dto.ResponseDataInterface;
import cn.insmart.mp.toutiao.common.bo.ResponseInterface;
import cn.insmart.mp.toutiao.common.constants.ResponseConstants;
import cn.insmart.mp.toutiao.common.exception.SdkResponseException;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import javax.annotation.Nonnull;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ResponseVO<T extends ResponseDataInterface>
implements ResponseInterface {
    private Long code;
    private Long mpLogId;
    private Long mpId;
    private Long toutiaoId;
    private String message;
    private String requestId;
    T data;

    public ResponseVO(T t, @Nonnull SdkResponseException sdkResponseException) {
        this.code = sdkResponseException.getCode();
        this.mpLogId = 0L;
        this.mpId = 0L;
        this.toutiaoId = 0L;
        this.message = sdkResponseException.getMessage();
        this.requestId = sdkResponseException.getRequestId();
        this.data = t;
    }

    public ResponseVO(@Nonnull Exception exception) {
        this.code = ResponseConstants.ERROR;
        this.mpLogId = 0L;
        this.mpId = 0L;
        this.toutiaoId = 0L;
        this.message = exception.getMessage();
        this.requestId = "";
        this.data = null;
    }

    public ResponseVO(T t) {
        this.code = ResponseConstants.RESPONSE_OK;
        this.mpLogId = 0L;
        this.mpId = 0L;
        this.toutiaoId = 0L;
        this.message = "success";
        this.requestId = "";
        this.data = t;
    }

    public String getFormatMessage() {
        return String.format("%s: %s. %s", this.getCode(), this.getMessage(), this.getRequestId());
    }

    public Long getCode() {
        return this.code;
    }

    public Long getMpLogId() {
        return this.mpLogId;
    }

    public Long getMpId() {
        return this.mpId;
    }

    public Long getToutiaoId() {
        return this.toutiaoId;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public T getData() {
        return this.data;
    }

    public ResponseVO<T> setCode(Long code) {
        this.code = code;
        return this;
    }

    public ResponseVO<T> setMpLogId(Long mpLogId) {
        this.mpLogId = mpLogId;
        return this;
    }

    public ResponseVO<T> setMpId(Long mpId) {
        this.mpId = mpId;
        return this;
    }

    public ResponseVO<T> setToutiaoId(Long toutiaoId) {
        this.toutiaoId = toutiaoId;
        return this;
    }

    public ResponseVO<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public ResponseVO<T> setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public ResponseVO<T> setData(T data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseVO)) {
            return false;
        }
        ResponseVO other = (ResponseVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$code = this.getCode();
        Long other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        Long this$mpLogId = this.getMpLogId();
        Long other$mpLogId = other.getMpLogId();
        if (this$mpLogId == null ? other$mpLogId != null : !((Object)this$mpLogId).equals(other$mpLogId)) {
            return false;
        }
        Long this$mpId = this.getMpId();
        Long other$mpId = other.getMpId();
        if (this$mpId == null ? other$mpId != null : !((Object)this$mpId).equals(other$mpId)) {
            return false;
        }
        Long this$toutiaoId = this.getToutiaoId();
        Long other$toutiaoId = other.getToutiaoId();
        if (this$toutiaoId == null ? other$toutiaoId != null : !((Object)this$toutiaoId).equals(other$toutiaoId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        Long $mpLogId = this.getMpLogId();
        result = result * 59 + ($mpLogId == null ? 43 : ((Object)$mpLogId).hashCode());
        Long $mpId = this.getMpId();
        result = result * 59 + ($mpId == null ? 43 : ((Object)$mpId).hashCode());
        Long $toutiaoId = this.getToutiaoId();
        result = result * 59 + ($toutiaoId == null ? 43 : ((Object)$toutiaoId).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseVO(code=" + this.getCode() + ", mpLogId=" + this.getMpLogId() + ", mpId=" + this.getMpId() + ", toutiaoId=" + this.getToutiaoId() + ", message=" + this.getMessage() + ", requestId=" + this.getRequestId() + ", data=" + this.getData() + ")";
    }

    public ResponseVO(Long code, Long mpLogId, Long mpId, Long toutiaoId, String message, String requestId, T data) {
        this.code = code;
        this.mpLogId = mpLogId;
        this.mpId = mpId;
        this.toutiaoId = toutiaoId;
        this.message = message;
        this.requestId = requestId;
        this.data = data;
    }

    public ResponseVO() {
    }
}

