/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.common.util;

import cn.hutool.core.util.RandomUtil;
import cn.insmart.fx.common.lang.util.ArrayUtils;
import cn.insmart.fx.common.lang.util.Message;
import cn.insmart.fx.common.lang.util.NumberUtils;
import cn.insmart.fx.common.lang.util.StringUtils;
import cn.insmart.mp.toutiao.common.bo.CreativeWord;
import cn.insmart.mp.toutiao.common.bo.ResponseInterface;
import cn.insmart.mp.toutiao.common.constants.ApiConstants;
import cn.insmart.mp.toutiao.common.constants.ResponseConstants;
import cn.insmart.mp.toutiao.common.enums.SerialTag;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ToutiaoCommonUtils {
    private static final Logger log = LoggerFactory.getLogger(ToutiaoCommonUtils.class);
    public static final Pattern creativeWordPattern = Pattern.compile("[{][^}]*}");

    public static Long[] getCreativeWordIdsFromTitle(String title, Map<String, CreativeWord> creativeWordMap) throws IllegalArgumentException {
        Object[] result = (Long[])creativeWordPattern.matcher(title).results().map(matchResult -> {
            String key = matchResult.group();
            if (creativeWordMap.containsKey(key)) {
                return ((CreativeWord)creativeWordMap.get(key)).getCreativeWordId();
            }
            return 0L;
        }).filter(id -> id > 0L).toArray(Long[]::new);
        Assert.isTrue((ArrayUtils.getLength((Object)result) <= 2 ? 1 : 0) != 0, (String)Message.of((String)"\u52a8\u6001\u8bcd\u5305\u8d85\u957f, {}. {}", (Object[])new Object[]{title, Arrays.toString(result)}));
        return result;
    }

    public static String replaceTitle(String title, String shortTitle, String ecoTitle, String ecoShortTitle, @NotNull String mainSerialName, @NotNull String relateSerialName1, @NotNull String relateSerialName2, @NotNull String mainManufacturerName, @NotNull String relateManufacturerName1, @NotNull String relateManufacturerName2, @NotNull String mainBrandName, @NotNull String relateBrandName1, @NotNull String relateBrandName2) {
        return ToutiaoCommonUtils.replaceTitle(ApiConstants.CREATIVE_WORD_MAP, title, shortTitle, ecoTitle, ecoShortTitle, mainSerialName, relateSerialName1, relateSerialName2, mainManufacturerName, relateManufacturerName1, relateManufacturerName2, mainBrandName, relateBrandName1, relateBrandName2);
    }

    public static String replaceTitle(Map<String, CreativeWord> creativeWordMap, String title, String shortTitle, String ecoTitle, String ecoShortTitle, @NotNull String mainSerialName, @NotNull String relateSerialName1, @NotNull String relateSerialName2, @NotNull String mainManufacturerName, @NotNull String relateManufacturerName1, @NotNull String relateManufacturerName2, @NotNull String mainBrandName, @NotNull String relateBrandName1, @NotNull String relateBrandName2) {
        String replacedTitle = ToutiaoCommonUtils.replaceSerialInfo(title, mainSerialName, relateSerialName1, relateSerialName2, mainManufacturerName, relateManufacturerName1, relateManufacturerName2, mainBrandName, relateBrandName1, relateBrandName2);
        if (ToutiaoCommonUtils.isTitleLengthOk(replacedTitle, creativeWordMap)) {
            return replacedTitle;
        }
        replacedTitle = ToutiaoCommonUtils.replaceSerialInfo(shortTitle, mainSerialName, relateSerialName1, relateSerialName2, mainManufacturerName, relateManufacturerName1, relateManufacturerName2, mainBrandName, relateBrandName1, relateBrandName2);
        if (ToutiaoCommonUtils.isTitleLengthOk(replacedTitle, creativeWordMap)) {
            return replacedTitle;
        }
        if (StringUtils.contains((CharSequence)mainSerialName, (CharSequence)"\u65b0\u80fd\u6e90")) {
            String newRelateSerialName2;
            String newRelateSerialName1 = StringUtils.remove((String)relateBrandName1, (String)"\u65b0\u80fd\u6e90");
            replacedTitle = ToutiaoCommonUtils.replaceSerialInfo(ecoTitle, mainSerialName, newRelateSerialName1, newRelateSerialName2 = StringUtils.remove((String)relateBrandName2, (String)"\u65b0\u80fd\u6e90"), mainManufacturerName, relateManufacturerName1, relateManufacturerName2, mainBrandName, relateBrandName1, relateBrandName2);
            if (ToutiaoCommonUtils.isTitleLengthOk(replacedTitle, creativeWordMap)) {
                return replacedTitle;
            }
            replacedTitle = ToutiaoCommonUtils.replaceSerialInfo(ecoShortTitle, mainSerialName, newRelateSerialName1, newRelateSerialName2, mainManufacturerName, relateManufacturerName1, relateManufacturerName2, mainBrandName, relateBrandName1, relateBrandName2);
            if (ToutiaoCommonUtils.isTitleLengthOk(replacedTitle, creativeWordMap)) {
                return replacedTitle;
            }
        }
        return replacedTitle;
    }

    public static String replaceSerialInfo(String sourceTitle, String mainSerialName, String relateSerialName1, String relateSerialName2, String mainManufacturerName, String relateManufacturerName1, String relateManufacturerName2, String mainBrandName, String relateBrandName1, String relateBrandName2) {
        if (StringUtils.isBlank((CharSequence)sourceTitle)) {
            return "";
        }
        return sourceTitle.replace(SerialTag.MAIN_SERIAL_1.getValue(), mainSerialName).replace(SerialTag.RELATE_SERIAL_1.getValue(), relateSerialName1).replace(SerialTag.RELATE_SERIAL_2.getValue(), relateSerialName2).replace(SerialTag.MAIN_MANUFACTURER_1.getValue(), mainManufacturerName).replace(SerialTag.RELATE_MANUFACTURER_1.getValue(), relateManufacturerName1).replace(SerialTag.RELATE_MANUFACTURER_2.getValue(), relateManufacturerName2).replace(SerialTag.MAIN_BRAND_1.getValue(), mainBrandName).replace(SerialTag.RELATE_BRAND_1.getValue(), relateBrandName1).replace(SerialTag.RELATE_BRAND_2.getValue(), relateBrandName2);
    }

    public static String[] addKeywords(List<String> sourceKeywordList) {
        return (String[])sourceKeywordList.stream().filter(keyword -> StringUtils.length((CharSequence)keyword) <= 10).limit(20L).toArray(String[]::new);
    }

    @Deprecated
    public static int calTitleLength(String title, Map<String, CreativeWord> creativeWordMap) throws IllegalArgumentException {
        String replacement = title;
        double len = 0.0;
        for (Map.Entry<String, CreativeWord> wordEntry : creativeWordMap.entrySet()) {
            if (!StringUtils.contains((CharSequence)title, (CharSequence)wordEntry.getKey())) continue;
            replacement = StringUtils.replace((String)replacement, (String)wordEntry.getKey(), (String)wordEntry.getValue().getMaxlengthWord());
        }
        Assert.isTrue((!StringUtils.contains((CharSequence)replacement, (CharSequence)"{") && !StringUtils.contains((CharSequence)replacement, (CharSequence)"}") ? 1 : 0) != 0, (String)Message.of((String)"{}, \u5305\u542b\u975e\u6cd5\u7684\u82b1\u62ec\u53f7", (Object[])new Object[]{title}));
        for (int i = 0; i < StringUtils.length((CharSequence)replacement); ++i) {
            char tempChar = replacement.charAt(i);
            if (Character.isLowerCase(tempChar) || Character.isUpperCase(tempChar) || Character.isDigit(tempChar) || !Character.isAlphabetic(tempChar)) {
                if (tempChar > '\ufee0' || tempChar == '\u3000') {
                    len += 1.0;
                    continue;
                }
                len += 0.5;
                continue;
            }
            len += 1.0;
        }
        BigDecimal returnLen = BigDecimal.valueOf(len);
        returnLen = returnLen.setScale(0, RoundingMode.CEILING);
        return returnLen.intValue();
    }

    public static boolean isTitleLengthOk(String title, Map<String, CreativeWord> creativeWordMap) throws IllegalArgumentException {
        LengthRange len = ToutiaoCommonUtils.calLengthRange(title, creativeWordMap);
        return 5 <= len.getMinLength() && len.getMaxLength() <= 55;
    }

    public static boolean isAbstractTextLengthOk(String abstractText, Map<String, CreativeWord> creativeWordMap) throws IllegalArgumentException {
        LengthRange len = ToutiaoCommonUtils.calLengthRange(abstractText, creativeWordMap);
        return 25 <= len.getMinLength() && len.getMaxLength() <= 45;
    }

    public static LengthRange calLengthRange(String title, Map<String, CreativeWord> creativeWordMap) throws IllegalArgumentException {
        String maxReplacement = title;
        String minReplacement = title;
        for (Map.Entry<String, CreativeWord> wordEntry : creativeWordMap.entrySet()) {
            if (!StringUtils.contains((CharSequence)title, (CharSequence)wordEntry.getKey())) continue;
            maxReplacement = StringUtils.replace((String)maxReplacement, (String)wordEntry.getKey(), (String)wordEntry.getValue().getMaxlengthWord());
            minReplacement = StringUtils.replace((String)minReplacement, (String)wordEntry.getKey(), (String)wordEntry.getValue().getMinlengthWord());
        }
        Assert.isTrue((!StringUtils.contains((CharSequence)maxReplacement, (CharSequence)"{") && !StringUtils.contains((CharSequence)maxReplacement, (CharSequence)"}") && !StringUtils.contains((CharSequence)minReplacement, (CharSequence)"{") && !StringUtils.contains((CharSequence)minReplacement, (CharSequence)"}") ? 1 : 0) != 0, (String)Message.of((String)"{}, \u5305\u542b\u975e\u6cd5\u7684\u82b1\u62ec\u53f7", (Object[])new Object[]{title}));
        LengthRange returnObj = new LengthRange();
        returnObj.setMaxLength(ToutiaoCommonUtils.calToutiaoWidthLength(maxReplacement));
        returnObj.setMinLength(ToutiaoCommonUtils.calToutiaoWidthLength(minReplacement));
        return returnObj;
    }

    public static int calToutiaoWidthLength(String str) {
        double len = 0.0;
        for (int i = 0; i < StringUtils.length((CharSequence)str); ++i) {
            char tempChar = str.charAt(i);
            if (Character.isLowerCase(tempChar) || Character.isUpperCase(tempChar) || Character.isDigit(tempChar) || !Character.isAlphabetic(tempChar)) {
                if (tempChar > '\ufee0' || tempChar == '\u3000') {
                    len += 1.0;
                    continue;
                }
                len += 0.5;
                continue;
            }
            len += 1.0;
        }
        int returnLen = BigDecimal.valueOf(len).setScale(0, RoundingMode.CEILING).intValue();
        log.info("stringLen {}, {}", (Object)str, (Object)returnLen);
        return returnLen;
    }

    @Deprecated
    public static String[] parseScheduleTimeToHour(String scheduleTime) {
        String[] result = new String[7];
        if (StringUtils.isBlank((CharSequence)scheduleTime) || scheduleTime.length() != 336) {
            return result;
        }
        for (int i = 0; i < 7; ++i) {
            String oneDay = scheduleTime.substring(i * 48, (i + 1) * 48);
            result[i] = ToutiaoCommonUtils.parseOneDayScheduleTimeToHourRanges(oneDay);
        }
        return result;
    }

    @Deprecated
    public static String parseHourRangesToScheduleTime(String oneDayHourStr) {
        if (StringUtils.isBlank((CharSequence)oneDayHourStr)) {
            return null;
        }
        String[] hourRangeArr = oneDayHourStr.split(",");
        StringBuilder stringBuilder = new StringBuilder("000000000000000000000000000000000000000000000000");
        for (String hourRange : hourRangeArr) {
            if (StringUtils.isBlank((CharSequence)hourRange)) continue;
            String[] hours = hourRange.trim().split("-", 2);
            if (hours.length == 1) {
                int hour = NumberUtils.toInt((String)hours[0], (int)-1);
                if (hour < 0 || hour > 23) continue;
                stringBuilder.replace(hour * 2, (hour + 1) * 2, "11");
                continue;
            }
            if (hours.length != 2) continue;
            int beginHour = NumberUtils.toInt((String)hours[0], (int)-1);
            int endHour = NumberUtils.toInt((String)hours[1], (int)-1);
            if (beginHour < 0 || beginHour > 23 || endHour < 0 || endHour > 23) continue;
            for (int i = beginHour; i <= endHour; ++i) {
                stringBuilder.replace(i * 2, (i + 1) * 2, "11");
            }
        }
        String oneDay = stringBuilder.toString();
        stringBuilder.append(oneDay.repeat(6));
        return stringBuilder.toString();
    }

    @Deprecated
    public static String parseOneDayScheduleTimeToHourRanges(String scheduleTime) {
        if (StringUtils.isBlank((CharSequence)scheduleTime) || scheduleTime.length() != 48) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(scheduleTime);
        StringBuilder returnStr = new StringBuilder();
        boolean preIsZero = true;
        int lastHour = 0;
        int cnt = 0;
        int i = 0;
        while (i < 25) {
            int now;
            int n = now = i < 24 ? (int)stringBuilder.charAt(i * 2) : 48;
            if (preIsZero && now == 49) {
                ++cnt;
                returnStr.append(i);
            } else if (!preIsZero) {
                if (now == 48) {
                    if (cnt == 1) {
                        returnStr.append(",");
                    } else if (cnt > 1) {
                        returnStr.append("-").append(lastHour).append(",");
                    }
                    cnt = 0;
                }
                if (now == 49) {
                    ++cnt;
                }
            }
            preIsZero = now == 48;
            lastHour = i++;
        }
        if (returnStr.length() > 1) {
            returnStr.setLength(returnStr.length() - 1);
        }
        return returnStr.toString();
    }

    public static String parseScheduleTime(String enableScheduleString) throws IndexOutOfBoundsException {
        if (StringUtils.isBlank((CharSequence)enableScheduleString)) {
            return "000000000000000000000000000000000000000000000000";
        }
        int[] schedule = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Arrays.stream(StringUtils.split((String)enableScheduleString)).filter(org.apache.commons.lang3.StringUtils::isNotBlank).forEach(t -> {
            try {
                if (StringUtils.contains((CharSequence)t, (CharSequence)"-")) {
                    String[] range = t.split("-", 2);
                    ToutiaoCommonUtils.setValue(schedule, Integer.parseInt(range[0]), Integer.parseInt(range[1]), 1);
                } else {
                    int idx = Integer.parseInt(t);
                    ToutiaoCommonUtils.setValue(schedule, idx, idx, 1);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        });
        log.info("parse {} -> {} ", (Object)enableScheduleString, (Object)Arrays.toString(schedule));
        return Arrays.stream(schedule).mapToObj(hour -> hour == 0 ? "00" : "11").collect(Collectors.joining());
    }

    public static boolean responseIsOk(ResponseInterface response) {
        return response != null && ResponseConstants.RESPONSE_OK.equals(response.getCode());
    }

    public static boolean responseIsLogicError(ResponseInterface response) {
        return response != null && ResponseConstants.LOGIC_ERROR_40000.equals(response.getCode());
    }

    public static boolean responseIsInvalidToken(ResponseInterface response) {
        return response != null && ResponseConstants.LOGIC_ERROR_40105.equals(response.getCode()) && StringUtils.contains((CharSequence)response.getMessage(), (CharSequence)"Access token is invalid");
    }

    public static boolean responseSdkAdNameExist(ResponseInterface response) {
        return response != null && ResponseConstants.LOGIC_ERROR_40000.equals(response.getCode()) && StringUtils.startsWith((CharSequence)response.getMessage(), (CharSequence)ResponseConstants.AD_NAME_EXIST);
    }

    public static boolean responseSdkCampaignNameExist(ResponseInterface response) {
        return response != null && ResponseConstants.LOGIC_ERROR_40000.equals(response.getCode()) && StringUtils.startsWith((CharSequence)response.getMessage(), (CharSequence)ResponseConstants.CAMPAIGN_NAME_EXIST);
    }

    public static boolean responseObjectExist(ResponseInterface response) {
        return response != null && ResponseConstants.LOGIC_ERROR_40000.equals(response.getCode()) && StringUtils.startsWith((CharSequence)response.getMessage(), (CharSequence)ResponseConstants.MP_MESSAGE_EXIST);
    }

    public static boolean responseCreativeAlreadyCreate(ResponseInterface response) {
        return ToutiaoCommonUtils.responseIsLogicError(response) && StringUtils.startsWith((CharSequence)response.getMessage(), (CharSequence)"\u521b\u610f\u5df2\u521b\u5efa\u6210\u529f");
    }

    private static void setValue(int[] scheduleArray, int startIncludeIndex, int endIncludeIndex, int result) throws IllegalArgumentException {
        int length = ArrayUtils.getLength((Object)scheduleArray);
        if (endIncludeIndex < startIncludeIndex || startIncludeIndex > length || startIncludeIndex < 0) {
            throw new IllegalArgumentException(Message.of((String)"\u8f6c\u6362\u65f6\u95f4\u51fa\u9519. \u8303\u56f4: [{}, {}]", (Object[])new Object[]{startIncludeIndex, endIncludeIndex}));
        }
        if (startIncludeIndex == endIncludeIndex) {
            scheduleArray[startIncludeIndex] = result;
        } else {
            int end = Math.min(endIncludeIndex, length);
            for (int i = startIncludeIndex; i < end; ++i) {
                scheduleArray[i] = result;
            }
        }
    }

    private static String generateRandomCode(int size) {
        int length;
        StringBuilder stringBuilder = new StringBuilder();
        int n = length = size > 6 || size < 0 ? 6 : size;
        while (length > 0) {
            stringBuilder.append(RandomUtil.randomInt((int)0, (int)10));
            --length;
        }
        return stringBuilder.toString();
    }

    public static Long getActivityId(String promotionName) {
        long actId = 0L;
        if (StringUtils.isNotBlank((CharSequence)promotionName)) {
            String[] split;
            for (String str : split = promotionName.split("-")) {
                if (!ToutiaoCommonUtils.isNumber(str = str.trim())) continue;
                actId = Long.parseLong(str);
                break;
            }
        }
        return actId;
    }

    private static boolean isNumber(String content) {
        Pattern compile = Pattern.compile("(^[0-9]+$)");
        Matcher matcher = compile.matcher(content);
        return matcher.find();
    }

    public static void main(String[] args) throws Exception {
    }

    public static class LengthRange {
        private int minLength;
        private int maxLength;

        public int getMinLength() {
            return this.minLength;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public void setMinLength(int minLength) {
            this.minLength = minLength;
        }

        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LengthRange)) {
                return false;
            }
            LengthRange other = (LengthRange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMinLength() != other.getMinLength()) {
                return false;
            }
            return this.getMaxLength() == other.getMaxLength();
        }

        protected boolean canEqual(Object other) {
            return other instanceof LengthRange;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMinLength();
            result = result * 59 + this.getMaxLength();
            return result;
        }

        public String toString() {
            return "ToutiaoCommonUtils.LengthRange(minLength=" + this.getMinLength() + ", maxLength=" + this.getMaxLength() + ")";
        }
    }
}

