/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.common.exception;

import cn.insmart.mp.toutiao.common.bo.ResponseInterface;
import cn.insmart.mp.toutiao.common.constants.ResponseConstants;
import java.util.Objects;

public class SdkResponseException
extends RuntimeException {
    private final Long code;
    private final String message;
    private final String requestId;

    public SdkResponseException(Long code, String message) {
        super(message);
        this.code = code;
        this.message = message;
        this.requestId = "";
    }

    public SdkResponseException(String message) {
        super(message);
        this.code = ResponseConstants.LOGIC_ERROR_40000;
        this.message = message;
        this.requestId = "";
    }

    public SdkResponseException(ResponseInterface response) {
        super(String.format("code: %s. message: %s. requestId: %s", Objects.requireNonNull(response, "response is null").getCode(), response.getMessage(), response.getRequestId()));
        this.code = response.getCode();
        this.message = response.getMessage();
        this.requestId = response.getRequestId();
    }

    public Long getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getRequestId() {
        return this.requestId;
    }
}

