/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.common.property;

import cn.insmart.fx.common.lang.util.ResourceUtils;
import cn.insmart.mp.toutiao.common.bo.AreaBO;
import cn.insmart.mp.toutiao.common.bo.CreativeWord;
import cn.insmart.mp.toutiao.common.constants.ApiConstants;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="mp.toutiao.config")
public class ToutiaoCommonProperties {
    private static final Logger log = LoggerFactory.getLogger(ToutiaoCommonProperties.class);
    public int interfaceGetMaxIdSize = 100;
    private Map<String, CreativeWord> creativeWordMap = ApiConstants.CREATIVE_WORD_MAP;

    public Map<Integer, AreaBO> getToutiaoArea() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map baseMap = (Map)mapper.readValue(ResourceUtils.getResourceAsStream((String)"areaFile/toutiao-cities.json"), mapper.constructType(Map.class));
            return baseMap.values().stream().map(o -> {
                AreaBO areaBO = (AreaBO)mapper.convertValue(o, AreaBO.class);
                log.info("areaBo {}", (Object)areaBO);
                return areaBO;
            }).collect(Collectors.toMap(AreaBO::getId, areaBO -> areaBO));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyMap();
        }
    }

    @Deprecated
    public void copyComponentLogo(String name, File file) throws IOException {
        Files.copy(ResourceUtils.getResourceAsStream((String)("ComponentLogo/" + name)), file.toPath(), new CopyOption[0]);
    }

    public void copyProductLogo(String name, File file) throws IOException {
        Files.copy(ResourceUtils.getResourceAsStream((String)("ProductLogo/" + name)), file.toPath(), new CopyOption[0]);
    }

    public int getInterfaceGetMaxIdSize() {
        return this.interfaceGetMaxIdSize;
    }

    public Map<String, CreativeWord> getCreativeWordMap() {
        return this.creativeWordMap;
    }

    public void setInterfaceGetMaxIdSize(int interfaceGetMaxIdSize) {
        this.interfaceGetMaxIdSize = interfaceGetMaxIdSize;
    }

    public void setCreativeWordMap(Map<String, CreativeWord> creativeWordMap) {
        this.creativeWordMap = creativeWordMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToutiaoCommonProperties)) {
            return false;
        }
        ToutiaoCommonProperties other = (ToutiaoCommonProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInterfaceGetMaxIdSize() != other.getInterfaceGetMaxIdSize()) {
            return false;
        }
        Map<String, CreativeWord> this$creativeWordMap = this.getCreativeWordMap();
        Map<String, CreativeWord> other$creativeWordMap = other.getCreativeWordMap();
        return !(this$creativeWordMap == null ? other$creativeWordMap != null : !((Object)this$creativeWordMap).equals(other$creativeWordMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ToutiaoCommonProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInterfaceGetMaxIdSize();
        Map<String, CreativeWord> $creativeWordMap = this.getCreativeWordMap();
        result = result * 59 + ($creativeWordMap == null ? 43 : ((Object)$creativeWordMap).hashCode());
        return result;
    }

    public String toString() {
        return "ToutiaoCommonProperties(interfaceGetMaxIdSize=" + this.getInterfaceGetMaxIdSize() + ", creativeWordMap=" + this.getCreativeWordMap() + ")";
    }
}

