/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.common.expander;

import cn.insmart.fx.common.lang.util.StringUtils;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import feign.Param;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class JsonExpander
implements Param.Expander {
    public String expand(Object value) {
        ObjectMapper om = new ObjectMapper();
        JavaTimeModule timeModule = new JavaTimeModule();
        timeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        timeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        om.registerModule((Module)timeModule);
        String returnValue = om.writeValueAsString(value);
        if (value instanceof LocalDate || value instanceof LocalDateTime) {
            return StringUtils.replace((String)returnValue, (String)"\"", (String)"");
        }
        return returnValue;
    }
}

