/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.sdk.request.bo;

import cn.insmart.mp.toutiao.sdk.request.bo.JsonAnnotation;
import cn.insmart.mp.toutiao.sdk.request.bo.RequestData;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import feign.Param;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.validation.constraints.Max;
import org.bouncycastle.util.Arrays;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ClueSelect
implements RequestData,
JsonAnnotation {
    @Param(value="advertiser_ids")
    private String advertiserIds;
    @Param(value="start_time")
    private String startTime;
    @Param(value="end_time")
    private String endTime;
    @Param(value="page")
    private Integer page = 1;
    @Param(value="page_size")
    @Max(value=100L)
    private @Max(value=100L) Integer pageSize = 100;

    public Long[] getAdvertiserIds() {
        return JSON.parseArray((String)this.advertiserIds, Long.class).toArray(new Long[0]);
    }

    public void setAdvertiserIds(Long[] advertiserIds) {
        this.advertiserIds = JSON.toJSONString((Object)advertiserIds);
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime != null ? DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(startTime) : null;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime != null ? DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(endTime) : null;
    }

    @Override
    public Long getTtAdvertiserId() {
        return Arrays.isNullOrEmpty((Object[])this.getAdvertiserIds()) ? null : this.getAdvertiserIds()[0];
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public ClueSelect setPage(Integer page) {
        this.page = page;
        return this;
    }

    public ClueSelect setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClueSelect)) {
            return false;
        }
        ClueSelect other = (ClueSelect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$page = this.getPage();
        Integer other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        if (!java.util.Arrays.deepEquals(this.getAdvertiserIds(), other.getAdvertiserIds())) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        return !(this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClueSelect;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        result = result * 59 + java.util.Arrays.deepHashCode(this.getAdvertiserIds());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        return result;
    }

    public String toString() {
        return "ClueSelect(advertiserIds=" + java.util.Arrays.deepToString(this.getAdvertiserIds()) + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ")";
    }
}

