/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.sdk.support;

import cn.insmart.fx.common.lang.util.MapUtils;
import cn.insmart.mp.toutiao.sdk.configuration.SdkProperties;
import cn.insmart.mp.toutiao.sdk.support.ApiServiceFactory;
import cn.insmart.mp.toutiao.sdk.support.ApiServiceFactoryManager;
import cn.insmart.mp.toutiao.sdk.support.CacheApiServiceFactory;
import cn.insmart.mp.toutiao.sdk.support.DefaultApiServiceFactory;
import cn.insmart.mp.toutiao.sdk.support.TokenProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApiServiceFactoryManager
implements ApiServiceFactoryManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultApiServiceFactoryManager.class);
    private final Map<String, ApiServiceFactory> factoryMap = new ConcurrentHashMap<String, ApiServiceFactory>();
    private final TokenProvider tokenProvider;
    private final SdkProperties sdkProperties;
    private static final String FACTORY_MAP_DEFAULT_KEY = "factoryDefaultKey";

    public DefaultApiServiceFactoryManager(TokenProvider tokenProvider, SdkProperties sdkProperties) {
        this.tokenProvider = Objects.requireNonNull(tokenProvider);
        this.sdkProperties = Objects.requireNonNull(sdkProperties);
    }

    @Override
    public ApiServiceFactory getApiServiceFactory() {
        return this.factoryMap.computeIfAbsent(FACTORY_MAP_DEFAULT_KEY, key -> this.sdkProperties.isCacheApiService() ? new CacheApiServiceFactory(this.sdkProperties, this.tokenProvider) : new DefaultApiServiceFactory(this.sdkProperties, this.tokenProvider));
    }

    @Override
    public ApiServiceFactory getApiServiceFactory(String serviceCacheKey) {
        return this.factoryMap.computeIfAbsent(serviceCacheKey, key -> this.sdkProperties.isCacheApiService() ? new CacheApiServiceFactory(this.sdkProperties, this.tokenProvider) : new DefaultApiServiceFactory(this.sdkProperties, this.tokenProvider));
    }

    @Override
    public List<Long> getManagerIds() {
        return this.sdkProperties.getAdvertiserMap().values().stream().map(advertiserProperties -> {
            if (Objects.equals(advertiserProperties.getAdvertiserId(), advertiserProperties.getManagerId())) {
                return advertiserProperties.getManagerId();
            }
            return 0L;
        }).filter(managerId -> managerId > 0L).collect(Collectors.toList());
    }

    @Override
    public Collection<SdkProperties.DefaultAdvertiserProperties> getAdvertiser() {
        return MapUtils.isEmpty(this.sdkProperties.getAdvertiserMap()) ? Collections.emptyList() : this.sdkProperties.getAdvertiserMap().values();
    }
}

