/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.sdk.support;

import cn.insmart.mp.toutiao.sdk.annotation.QpsLimit;
import com.google.common.util.concurrent.RateLimiter;
import feign.RequestLine;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class QpsLimiter {
    private static final Map<Method, RateLimiter> LIMITER_MAP = new ConcurrentHashMap<Method, RateLimiter>();

    public static RateLimiter get(Method method) {
        if (Objects.isNull(method.getAnnotation(RequestLine.class))) {
            return null;
        }
        QpsLimit qpsLimit = method.getAnnotation(QpsLimit.class);
        if (Objects.isNull(qpsLimit)) {
            return null;
        }
        return LIMITER_MAP.computeIfAbsent(method, m -> RateLimiter.create((double)qpsLimit.value()));
    }

    private QpsLimiter() {
    }
}

