/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.sdk.configuration;

import cn.insmart.mp.toutiao.sdk.configuration.SdkProperties;
import cn.insmart.mp.toutiao.sdk.support.ApiServiceFactoryManager;
import cn.insmart.mp.toutiao.sdk.support.DataSourceTokenProvider;
import cn.insmart.mp.toutiao.sdk.support.DefaultApiServiceFactoryManager;
import cn.insmart.mp.toutiao.sdk.support.DefaultTokenProvider;
import cn.insmart.mp.toutiao.sdk.support.TokenProvider;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SdkProperties.class})
public class SdkAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SdkAutoConfiguration.class);

    @Bean
    TokenProvider tokenProvider(SdkProperties properties) {
        log.info("toutiao SdkProperties {}", (Object)properties);
        SdkProperties.DataSourceProperties dataSourceProperties = properties.getDataSource();
        if (Objects.isNull(dataSourceProperties)) {
            log.info("\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6token");
            return new DefaultTokenProvider(properties);
        }
        log.info("\u4f7f\u7528\u6570\u636e\u5e93token");
        return new DataSourceTokenProvider(dataSourceProperties);
    }

    @Bean
    ApiServiceFactoryManager apiServiceFactoryManager(TokenProvider tokenProvider, SdkProperties properties) {
        log.info("toutiao sdk properties: {}, tokenProvider: {}", (Object)properties, (Object)tokenProvider.getClass().getSimpleName());
        return new DefaultApiServiceFactoryManager(tokenProvider, properties);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SdkAutoConfiguration)) {
            return false;
        }
        SdkAutoConfiguration other = (SdkAutoConfiguration)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof SdkAutoConfiguration;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "SdkAutoConfiguration()";
    }
}

